#if !defined __SCAN_H
#define      __SCAN_H


#include "fxttypes.h"
//#include "auxtempl.h"


template <typename Type>
ulong
first_eq_idx(const Type *f, ulong n, Type v)
// return index of first element == v
// returns n if all !=v
{
    ulong k = 0;
    while ( (k<n) && (f[k]!=v) )  k++;
    return k;
}
//-----------------------

template <typename Type>
ulong
first_ne_idx(const Type *f, ulong n, Type v)
// return index of first element != v
// returns n if all ==v
{
    ulong k = 0;
    while ( (k<n) && (f[k]==v) )  k++;
    return k;
}
//-----------------------


template <typename Type>
ulong
first_ge_idx(const Type *f, ulong n, Type v)
// returns index of first element >=v
// returns n if no such element is found
{
    for (ulong i=0; i<n; ++i)
    {
        if ( f[i]>=v )  return i;
    }
    return n;
}
//-----------------------


template <typename Type>
ulong
first_le_idx(const Type *f, ulong n, Type v)
// returns index of first element <=v
// returns n if no such element is found
{
    for (ulong i=0; i<n; ++i)
    {
        if ( f[i]<=v )  return i;
    }
    return n;
}
//-----------------------



template <typename Type>
ulong
last_eq_idx(const Type *f, ulong n, Type v)
// return index of last element == v
// returns n if all !=v
{
    ulong k = n-1;
    while ( f[k]!=v )
    {
        k--;
        if ( 0==k )  return n;
    }
    return k;
}
//-----------------------


template <typename Type>
ulong
last_ne_idx(const Type *f, ulong n, Type v)
// return index of last element != v
// returns n if all ==v
{
    ulong k = n-1;
    while ( f[k]==v )
    {
        k--;
        if ( 0==k )  return n;
    }
    return k;
}
//-----------------------


template <typename Type>
ulong
last_ge_idx(const Type *f, ulong n, Type v)
// return index of last element >= v
// returns n if all <v
{
    ulong k = n-1;
    while ( f[k]<v )
    {
        k--;
        if ( 0==k )  return n;
    }
    return k;
}
//-----------------------


template <typename Type>
ulong
last_le_idx(const Type *f, ulong n, Type v)
// return index of last element <= v
// returns n if all >v
{
    ulong k = n-1;
    while ( f[k]>v )
    {
        k--;
        if ( 0==k )  return n;
    }
    return k;
}
//-----------------------



template <typename Type>
ulong
eq_count(const Type *f, ulong n, Type v)
// returns number of elements that are ==v
{
    ulong ct = 0;
    while ( n-- )  if ( f[n]==v )  ++ct;
    return ct;
}
//-----------------------


template <typename Type>
ulong
ne_count(const Type *f, ulong n, Type v)
// returns number of elements that are !=v
{
    ulong ct = 0;
    while ( n-- )  if ( f[n]!=v )  ++ct;
    return ct;
}
//-----------------------


template <typename Type>
ulong
ge_count(const Type *f, ulong n, Type v)
// returns number of elements that are >=v
{
    ulong ct = 0;
    while ( n-- )  if ( f[n]>=v )  ++ct;
    return ct;
}
//-----------------------


template <typename Type>
ulong
le_count(const Type *f, ulong n, Type v)
// returns number of elements that are <=v
{
    ulong ct = 0;
    while ( n-- )  if ( f[n]<=v )  ++ct;
    return ct;
}
//-----------------------


#endif // !defined __SCAN_H
