
#include <math.h>

#include "fxt.h"
#include "auxbit.h"
#include "copy.h"
#include "auxdouble.h"



void
fft_fract(double *x, double *y, ulong n, double v)
//
// fractional (fast) fourier transform
//
// for complex array c[0...n]
// compute \sum_{x=0}^{n}{c_x*exp(is*v*2*i*\pi*x*k/n)}
//  (for v==1.0 this is just the usual fft)
//
//  LITTLE TESTED !
//
// use n*k == n^2/2 + k^2/2 - (k-n)^2/2
// (see: nussbaumer: FFT and convolution algorithms 5.1)
// ( could use n*k == - n^2/2 - k^2/2 + (k+n)^2/2 instead )
//
// nn is the smallest power of 2 >=2*n
//
// worst case if n=2^x+1:
//   then nn=4*2^x
//   work is about 12 times a fft of length 2^x
//   and allocated workspace =4*nn
//
{
    ulong ldnn = ld(n);

    if ( n==(1UL<<ldnn) )  ldnn += 1;
    else                   ldnn += 2;

    ulong nn = (1<<ldnn);

    double *fr = new double[2*nn];
    double *fi = fr + nn;

//    ri_copy(x,y, fr,fi, n);
    copy(x, fr, n);
    copy(y, fi, n);

//    ri_null(fr+n, fi+n, nn-n);
    null(fr+n, nn-n);
    null(fi+n, nn-n);

    double *wr = new double[2*nn];
    double *wi = wr + nn;


//    v *= is;
    make_fft_fract_chirp(wr,wi, v, n, nn);

    ri_multiply(wr,wi, fr,fi, n);

    negate(wi, nn);
    fft_complex_convolution(wr,wi, fr,fi, ldnn);

    make_fft_fract_chirp(wr,wi, v, n, nn);

    ri_multiply(fr,fi, wr,wi, nn);


//    ri_copy(wr+n,wi+n, x,y, n);
    copy(wr+n, x, n);
    copy(wi+n, y, n);

    delete [] wr;
    delete [] fr;
}
// ============== end ================
