
#include "fxt.h"
#include "inline.h"


void
dsth(double *x, ulong ldn, double *tmp/*=0*/)
// basis: sin((k+1)*(i+0.5)*M_PI/n) * sqrt(2)
{
    ulong n = (1<<ldn);
    ulong nh = (n>>1);

    for (ulong k=1; k<n; k+=2)  x[k] = -x[k];
    
    dcth(x, ldn, tmp);
    
    for (ulong k=0; k<nh; k++)  swap(x[k], x[n-1-k]);
}
// =============== end =========== 


void
idsth(double *x, ulong ldn, double *tmp/*=0*/)
{
    ulong n = (1<<ldn);
    ulong nh = (n>>1);

    for (ulong k=0; k<nh; k++)  swap(x[k], x[n-1-k]);

    idcth(x, ldn, tmp);

    for (ulong k=1; k<n; k+=2)  x[k] = -x[k];  
}
// =============== end =========== 
