
#include "fxt.h"
#include "fxtdefs.h"


void
fht_fft_auto_convolution(double *f, ulong ldn)
// f[] = f[] (*) f[]
{
    fht_real_complex_fft(f,ldn);
    fft_auto_convolution_core1(f,ldn);
    fht_complex_real_fft(f,ldn);
}
//============ end ===============


void
split_radix_fft_auto_convolution(double *f, ulong ldn)
// f[] = f[] (*) f[]
{
    split_radix_real_complex_fft(f,ldn);
    fft_auto_convolution_core1(f,ldn);
    split_radix_complex_real_fft(f,ldn);
}
//============= end ==========


void
fht_fft_auto_convolution0(double *f, ulong ldn)
// f[] = f[] (*) f[]
{
    fht_real_complex_fft0(f,ldn);
    fft_auto_convolution_core1(f,ldn);
    fht_complex_real_fft(f,ldn);
}
//============ end ===============


void
split_radix_fft_auto_convolution0(double *f, ulong ldn)
// f[] = f[] (*) f[]
{
    split_radix_real_complex_fft0(f,ldn);
    fft_auto_convolution_core1(f,ldn);
    split_radix_complex_real_fft(f,ldn);
}
//============= end ==========


void
fft_auto_convolution_core1(double *f, ulong ldn, double v/*=0.0*/)
{
    const ulong n  = (1<<ldn);
    const ulong nh = n/2;

    if ( v==0.0 )  v = 1.0/n;

    f[0]  *= f[0] * v;
    f[nh] *= f[nh] * v;

    for (ulong i=1,j=n-1; i<nh; ++i,--j)
    {
        CSQR2_N(f[i], f[j], v);
    }
}
//============== end =============


void
fft_auto_convolution_core2(double *f, ulong ldn, double v/*=0.0*/)
{
    const ulong n  = (1<<ldn);
    const ulong nh = n/2;

    if ( v==0.0 )  v = 1.0/n;

    f[0]  *= f[0] * v;
    f[nh] *= f[nh] * v;

    for (ulong i=1,j=nh+1; i<nh; ++i,++j)
    {
        CSQR2_N(f[i], f[j], v);
    }
}
//============== end =============
