
#include "fxt.h"
#include "fxtdefs.h"


#define  FFT(fr,fi,ldn,is)   fht_fft(fr,fi,ldn,is)


void
fft_complex_auto_correlation(double *fr, double *fi, ulong ldn)
//
// _cyclic_ (self-)correlation
// (use zero padded data for usual corr.)
//
// fr,fi must not overlap
//
{
    const int is = 1;
    const ulong n = (1<<ldn);

    FFT(fr,fi,ldn,is);

    const ulong nh = (n>>1);
    CSQR2(fr[0],  fi[0]);
    CSQR2(fr[nh], fi[nh]);
    double v = 1.0/n;
    for (ulong k=1,j=n-1; k<nh; k++,j--)
    {
        double r1 = fr[k];
        double i1 = fi[k];
        double r2 = fr[j];
        double i2 = fi[j];
        CMULT6(r1, i1, r2, i2, fr[k], fi[k]);
        fr[j] = fr[k] * v;
        fi[j] = fi[k] * v;
    }

    FFT(fr,fi,ldn,-is);
}
//=========================== end =================



void
fft_complex_correlation(double *fr, double *fi,
                        double *gr, double *gi,
                        ulong ldn)
//
// _cyclic_ correlation
// (use zero padded data for usual conv.)
//
// fr,fi,gr,gi must be pairwise non-overlapping
//
// result in gr,gi
//
{
//    assert( (fr!=gr) && (fr!=gi) );
//    assert( (fi!=gr) && (fi!=gi) );

    const int is = 1;
    const ulong n = (1<<ldn);

    FFT(fr,fi,ldn,-is);
    FFT(gr,gi,ldn,is);

    double v = 1.0/n;
    for (ulong k=0; k<n; ++k)
    {
        double tr = fr[k];
        double ti = fi[k];
        CMULT(gr[k], gi[k], tr, ti);
        gr[k] = tr * v;
        gi[k] = ti * v;
    }

    FFT(gr,gi,ldn,-is);
}
//=========================== end =================

