
#include "fxt.h"
#include "auxbit.h"
#include "copy.h"


#define  FFT(re,im,ldn,is)   fht_fft(re,im,ldn,is)
#define  FFT0(re,im,ldn,is)  fht_fft0(re,im,ldn,is)

void
skip_fft(double *fr, double *fi, ulong n, ulong d,
         double *wr, double *wi, int is)
//
// compute fft of the n elements
// [0],[d],[2d],[3d],...,[(n-1)*d]
{
    skip_copy(fr,wr,n,d);
    skip_copy(fi,wi,n,d);

    ulong ldn = ld(n);
    FFT(wr,wi,ldn,is);

    skip_copy_back(wr,fr,n,d);
    skip_copy_back(wi,fi,n,d);

}
// =============== end =========== 


void
skip_fft0(double *fr, double *fi, ulong n, ulong d,
          double *wr, double *wi, int is)
//
// compute fft of the n elements
// [0],[d],[2d],[3d],...,[(n-1)*d]
// version for zero padded data
{
    ulong nh = (n>>1);
    skip_copy(fr,wr,nh,d);
    null(wr+nh,nh);
    skip_copy(fi,wi,nh,d);
    null(wi+nh,nh);

    ulong ldn = ld(n);
    FFT0(wr,wi,ldn,is);

    skip_copy_back(wr,fr,n,d);
    skip_copy_back(wi,fi,n,d);
}
// =============== end ===========
