
#include "fxt.h"
#include "fxtdefs.h"  // SUMDIFF, CSQR, CMULT


#define  FHT_FFT_VERSION  0  // 0 or 1, doesn't matter

void
fht_fft(double *fr, double *fi, ulong ldn, int is)
// fft based on fht
{
#if  ( FHT_FFT_VERSION==1 )
    fht_fft_pre_processing(fr, fi, ldn, is);
    fht(fr, ldn);
    fht(fi, ldn);
#else // FHT_FFT_VERSION
// alternative version, else same as fht_fft():
    fht(fr, ldn);
    fht(fi, ldn);
    fht_fft_post_processing(fr, fi, ldn, is);
#endif // FHT_FFT_VERSION
}
// ================= end ===================


void
fht_fft0(double *fr, double *fi, ulong ldn, int is)
// fft based on fht
// version for zero padded data
{
    fht0(fr, ldn);
    fht0(fi, ldn);
    fht_fft_post_processing(fr, fi, ldn, is);
}
// ========================= end ===================


void
fht_fft_pre_processing(double *fr, double *fi, ulong ldn, int is)
// preprocessing to use two length-n fhts
// to compute a length-n complex fft
{
    const ulong n = (1<<ldn);
    const ulong nh = n/2;

    if ( is>0 )
    {
        for (ulong i=1,j=n-1; i<nh; i++,j--)
        {
            double q, r, s, t;
            SUMDIFF4(fr[i], fr[j], q, r);
            SUMDIFF4(fi[i], fi[j], s, t);
            SUMDIFF4_05(q, t, fr[j], fr[i]);
            SUMDIFF4_05(s, r, fi[i], fi[j]);
        }
    }
    else  // r,t negated
    {
        for (ulong i=1,j=n-1; i<nh; i++,j--)
        {
            double q, r, s, t;
            SUMDIFF4(fr[j], fr[i], q, r);
            SUMDIFF4(fi[j], fi[i], s, t);
            SUMDIFF4_05(q, t, fr[j], fr[i]);
            SUMDIFF4_05(s, r, fi[i], fi[j]);
        }
    }
}
// ================= end ===================

void
fht_fft_post_processing(double *fr, double *fi, ulong ldn, int is)
// postprocessing to use two length-n fhts
// to compute a length-n complex fft
{
    const ulong n = (1<<ldn);
    const ulong nh = n/2;
    double q, r, s, t;

    if ( is>0 )
    {
        for (ulong i=1,j=n-1; i<nh; i++,j--)
        {
            SUMDIFF4(fr[i], fr[j], q, r);
            SUMDIFF4(fi[i], fi[j], s, t);
            SUMDIFF4_05(q, t, fr[j], fr[i]);
            SUMDIFF4_05(s, r, fi[i], fi[j]);
        }
    }
    else  // r,t negated
    {
        for (ulong i=1,j=n-1; i<nh; i++,j--)
        {

            SUMDIFF4(fr[j], fr[i], q, r);
            SUMDIFF4(fi[j], fi[i], s, t);
            SUMDIFF4_05(q, t, fr[j], fr[i]);
            SUMDIFF4_05(s, r, fi[i], fi[j]);
        }
    }
}
// ================= end ===================
