
#include "copy.h"
#include "auxbit.h"
#include "fxt.h"


#define FHT(f,ldn)   fht(f,ldn)
#define FHT0(f,ldn)  fht0(f,ldn)


void
skip_fht(double *f, ulong n, ulong d, double *w)
//
// compute fht of the n elements
// [0],[d],[2d],[3d],...,[(n-1)*d]
//
{
    skip_copy(f,w,n,d);

    ulong ldn = ld(n);
    FHT(w,ldn);

    skip_copy_back(w,f,n,d);
}
// =============== end ===========


void
skip_fht0(double *f, ulong n, ulong d, double *w)
//
// compute fht of the n elements
// [0],[d],[2d],[3d],...,[(n-1)*d]
//
{
    ulong nh = (n>>1);
    skip_copy(f,w,nh,d);
    null(f+nh,nh);

    ulong ldn = ld(n);
    FHT0(w,ldn);

    skip_copy_back(w,f,n,d);
}
// =============== end ===========
