
#include "fxtaux.h"

#include <assert.h>  // atol()
#include <stdlib.h>  // atol()

#include <iostream.h>


static int ct = 0;

template <typename Type>
void 
pr_swap(Type &x, Type &y, ulong k, ulong r)
{
    ++ct;

    cout << "swap";
    if ( y==0 )  cout << "0";
    cout << "(f[" << k << "], f[" << r << "]);" << endl;

    swap(x, y);
}
// =========================

#define  swap(x,y)  pr_swap(x,y,k,r);


template <typename Type>
void
revbin_permute(Type *f, ulong n)
{
    const ulong nh = (n>>1);
    ulong m = nh;
    static ulong x[8 * sizeof(ulong)+1];
    x[0] = nh;
    for (ulong i=1; m; ++i)  // initialize xor-table
    {
        m >>= 1;
        x[i] = x[i-1] ^ m;
    }

    Type * const f1 = f + n - 1;
    ulong k=0, r=0;
    ulong i, n4 = nh/2;
    while ( k<n  )  // n>=8, nh>=4
    {
        // k even:
        if ( r>k )  swap(f[k], f[r]);  // k<nh, r<nh

        r ^= nh;
        ++k;

        // k odd:
        if ( r>k )  swap(f[k], f[r]);  // k<nh, r>nh

        m = 2;  i = 1;
        while ( m & k )  { m <<= 1;  ++i; } // scan for lowest unset bit of k
        r ^= x[i];
        ++k;
    }
}
// =========================


int
main(int argc, char **argv)
{
    ulong ldn = 4;
    if ( argc>1 )  ldn = atol(argv[1]);
    long n = 1<<ldn;

    int zq = 0;
    if ( argc>2 )  zq = 1;

    int *f = new int[n];
    fill_seq(f, n);
    if ( zq )  null(f+n/2, n/2);

//    cout << "#include \"inline.h\"" << endl;
    cout << endl;
    cout << "template <typename Type>" << endl;
    cout << "inline void" << endl;
    cout << "revbin_permute";
    if ( zq )  cout << "0";
    cout << "_" << n << "(Type *f)" << endl;
    cout << "// unrolled version for length " << n << endl;

    cout << "{" << endl;
    revbin_permute(f, n);
    cout << "}  // # of swaps = "<< ct << endl;


    revbin_permute(f, n);
    long i = 0;
    for (  ; i<n/2; ++i)  assert(f[i]==i);
    if ( zq )  for (  ; i<n; ++i)  assert(f[i]==0);
    else       for (  ; i<n; ++i)  assert(f[i]==i);

    return 0;
}
// =========================

// for ((i=1; i<=6; ++i)); do bin $i; done > shortrevbinpermute.h
// for ((i=1; i<=6; ++i)); do bin $i 1; done > shortrevbinpermute0.h

