#! /usr/bin/bash

ASFILE=$1;

#set -vx

if [ -f "$ASFILE" ]; then
  echo ''
  echo '//# count on (x86-) assembler output:'
  echo '//#  fmul:' `grep fmul $ASFILE | wc -l`
  echo '//#  fadd/fsub:' `grep f[as][du][db] $ASFILE | wc -l`
  echo '//#  load/store:' `grep '[(]%eb[xp][)]' $ASFILE | grep f | wc -l`
  echo '//#  fxch:' `grep fxch $ASFILE | wc -l`
  echo '//#  LC5x:' `grep ^.LC5 $ASFILE | wc -l`
  echo '//#  movl $:' `grep 'movl \\$' $ASFILE | wc -l`
  exit 0;
else
  exit 1;
fi

###################################
