
#include "fxt.h"
#include "auxbit.h"

#define  FFT(fr,fi,ldn,is)  fht_fft(fr,fi,ldn,is)
#define  FFTC(f,ldn,is)  fht_fft(f,ldn,is)


void
row_ffts(double *fr, double *fi, ulong r, ulong c, int is)
//
// r x c matrix (r rows of length c)
//
{
    ulong ldc = ld(c);
    double *pr = fr,  *pi = fi;
    for (ulong k=0; k<r; ++k)
    {
        FFT(pr, pi, ldc, is);  // jjnote: cache problem !

        pr += c;
        pi += c;
    }
}
// ================== end ===================


void
row_weighted_ffts(double *fr, double *fi, ulong r, ulong c, int is)
//
// r x c matrix (r rows of length c)
//
{
    ulong ldc = ld(c);
    double *pr = fr,  *pi = fi;
    for (ulong k=0; k<r; ++k)
    {
        fourier_shift(pr, pi, c, 1.0*is*k/r);  // jjnote: cache problem !
        FFT(pr, pi, ldc, is);  // jjnote: cache problem !

        pr += c;
        pi += c;
    }
}
// ================== end ===================


void
row_ffts(Complex *f, ulong r, ulong c, int is)
//
// r x c matrix (r rows of length c)
//
{
    ulong ldc = ld(c);
    Complex *p = f;
    for (ulong k=0; k<r; ++k)
    {
        FFTC(p, ldc, is);
        p += c;
    }
}
// ================== end ===================


void
row_weighted_ffts(Complex *f, ulong r, ulong c, int is)
//
// r x c matrix (r rows of length c)
//
{
    ulong ldc = ld(c);
    Complex *p = f;
    for (ulong k=0; k<r; ++k)
    {
        fourier_shift(p, c, 1.0*is*k/r);
        FFTC(p, ldc, is);
        p += c;
    }
}
// ================== end ===================

