
#include <assert.h>

#include "fxttypes.h"
#include "inline.h"


void
matrix_transpose2(double *x, ulong rw, ulong cl, double *tmp/*=0*/)
//
//  matrix transpose
//  only for n*n or n*2n or 2n*n matrix !
//
// scratchspace, if given must have size max(rw,cl)
{
    ulong i,j;
    ulong i1,i2;
    double *y, *z;

    assert( (rw==cl) || (rw==2*cl) || (2*rw==cl) );
 
    if ( rw==cl )
    {
        for (i=1; i<rw; ++i)
        {
            y = x+i*cl;
            z = x+i;
            for (j=0; j<i; ++j)
            {
                swap(*y,*z);
                y++;
                z += cl;
            }
        }
    }
    else  // rw!=cl
    {
        ulong mrc = (rw>cl ? rw : cl);  // max(rw,cl)
        double *wd;
        if ( tmp )  wd = tmp;
        else        wd = (double *)operator new (mrc*sizeof(double));
    
        if ( cl>rw )
        {
	    ulong clh = cl/2;
    
            for (i=0; i<rw; ++i)
            {    
                i1 = i*cl;
                i2 = i1+1;                 
                for (j=0; j<clh; j++)
                {
//                    i1 = i*cl+2*j;
//                    i2 = i*cl+2*j+1;
                    wd[j] =   x[i1];
                    wd[clh+j] = x[i2];

                    i1 += 2;
                    i2 += 2;
                }
    
                i1 = i*cl;
                for (j=0; j<cl; j++)
                {
//                    x[i*cl+j] = wd[j];
                    x[i1] = wd[j];
                    i1++;
                }
            }
    
            for (i=0; i<rw; ++i)
            {
                i1 = i*cl;
                i2 = i;
                for (j=0; j<i; ++j)
                {
//                    i1 = i*cl+j;
//                    i2 = j*cl+i;
                    swap(x[i1],x[i2]);
                    i1++;
                    i2 += cl;
                }
            }
    
            for (i=0; i<rw; ++i)
            {
                i1 = i*cl+clh;
                i2 = i+clh;
                for (j=0; j<i; ++j)
                {
//                    i1 = i*cl+clh+j;
//                    i2 = j*cl+clh+i;
                    swap(x[i1],x[i2]);
                    i1++;
                    i2 += cl;
                }
            }
        }
        else  // rw>cl
        {
	    ulong rwh = rw/2;    
            for (i=0; i<rwh; ++i)
            {
                i1 = i*rwh;
                i2 = i; 
                for (j=0; j<i; ++j)
                {
//                    i1 = i*rwh+j;
//                    i2 = j*rwh+i;
                    swap(x[i1],x[i2]);
                    i1++;
                    i2 += rwh;
                }
            }
    
            for (i=0; i<rwh; ++i)
            {
                i1 = rwh*(rwh+i);
                i2 = rwh*rwh+i;
                for (j=0; j<i; ++j)
                {
//                    i1 = rwh*rwh+i*rwh+j;
//                    i2 = rwh*rwh+i+j*rwh;
                    swap(x[i1],x[i2]);
                    i1++;
                    i2 += rwh;
                }
            }
    
            for (j=0; j<cl; ++j)
            {

                ulong i3 = 0; 
                i1 = j;
                i2 = j+rwh*rwh;
                for (i=0; i<rwh; ++i)
                {
//                    i1 = j+i*cl;
//                    i2 = j+rwh*rwh+i*cl;
//                    wd[2*i] =   x[i1];
//                    wd[2*i+1] = x[i2];
                    wd[i3] =   x[i1];
                    wd[++i3] = x[i2];
                    i3++;
                    i1 += cl;
                    i2 += cl;

                }
    
                i1 = j;
                for (i=0; i<rw; ++i)
                {
//                    i1 = j+i*cl;
                    x[i1] = wd[i];
                    i1 += cl;
                }
            }
        }

        if ( !tmp )  operator delete(wd);
    }
}
//=========================== end ==================================
