
#include "ntt.h"

//#include <iostream.h>

void
ntt_dit2(mod *f, ulong ldn, int is)
//
// radix 2 decimation in time mod fft
//
{
    const ulong n = 1<<ldn;

    revbin_permute(f,n);

    sumdiff2(f,n);

    for (ulong ldm=2; ldm<=ldn; ++ldm)
    {
        const ulong m = (1<<ldm);
        const ulong mh = (m>>1);

        const mod dw = mod::root2pow( is>0?ldm:-ldm );
	mod w = (mod::one);

        for (ulong j=0; j<mh; ++j)
        {
            for (ulong r=0; r<n; r+=m)
            {
                const ulong t1 = r+j;
                const ulong t2 = t1+mh;

                mod v = f[t2]*w;
                mod u = f[t1];

                f[t1] += v;
                f[t2] = u-v;
            }

	    w *= dw;
        }
    }
}
// =============== end =================
