
#include "mod.h"
#include "modm.h"
#include "jjassert.h"


#define  ORDER_PRINT  0  // 0 or 1 (for debug)

umod_t
order_mod(umod_t x, umod_t m, const factorization &phifact)
//
// finds order of x
// cf. cohen, p.25
//
{
    // pari says:  ***   not an element of (Z/nZ)* in order
    if ( 1!=gcd(m,x) )  return 0;

    umod_t h = phifact.product();

#if  ( ORDER_PRINT==1 )
    cout << "\n order(): ... " << endl;
    cout << " x=" << x << endl;
    cout << " m=" << m << endl;
    cout << "phifact=" << phifact << endl;
#endif

    umod_t e = h;
#if  ( ORDER_PRINT==1 )
    cout << " h=e=phi=" << e << endl; 
#endif

    for (int i=0; i<phifact.npr ; ++i)
    {
        umod_t p  = phifact.prime[i];
        long v    = phifact.expon[i];
        umod_t pp = phifact.factor(i);

#if  ( ORDER_PRINT==1 )
        cout << "\n p_i=" << p << "  v_i=" << v << endl;
        cout << "    p_i^{v_i}=P=" << pp << endl; 
        cout << "    e=" << e << endl; 
#endif
        jjassert( (e/pp)*pp==e );

        e /= pp;
#if  ( ORDER_PRINT==1 )
        cout << "   x=" << x << "  e=" << e << endl; 
#endif
        umod_t g1 = pow_mod(x,e,m);

#if  ( ORDER_PRINT==1 )
        cout << " local order, x^e = g1=" << g1 << ": \n";
        cout << "    e=" << e << endl; 
#endif

        while ( g1!=1 )
        {
            g1 = pow_mod(g1,p,m);
            e *= p;
#if  ( ORDER_PRINT==1 )
            assert ( g1!=(uint)0 );
            jjassert( e!=0 );
            jjassert( e<=h );  // e==h only possible if g1==1
#endif

            v--;
#if  ( ORDER_PRINT==1 )
            cout << "  v=" << v 
                 << ": g1=" << g1 
                 << "  p=" << p 
                 << "  e=" << e << "\n";
#endif
           jjassert( v>=0 );
        }
    }

    return e;
}
//================= end ================
