#if !defined __EVENODDPERMUTE_H
#define      __EVENODDPERMUTE_H


#include "fxttypes.h"
#include "revbinpermute.h"

// permute/evenoddpermute.cc:
void evenodd_permute(double *f, long n);
void inverse_evenodd_permute(double *f, long n);


template <typename Type>
void
evenodd_permute(Type *f, long n)
//
// lower half --> even indices
// higher half --> odd indices
//
// same as transposing the array as 2 x n/2 - matrix
//
// useful to combine real/imag part into a Complex array
{
    ulong nh = n/2;
    revbin_permute(f, nh);  revbin_permute(f+nh, nh);
    revbin_permute(f, n);
}
//============= end ============


template <typename Type>
void
inverse_evenodd_permute(Type *f, long n)
//
// inverse of evenodd_permute():
// put part of data with even indices
// sorted into the lower half,
// odd part into the higher half
//
// same as transposing the array as n/2 x 2 - matrix
//
// useful to separate real/imag part from a Complex array
{
    ulong nh = n/2;
    revbin_permute(f, n);
    revbin_permute(f, nh);  revbin_permute(f+nh, nh);
}
//============= end ============


#endif // !defined __EVENODDPERMUTE_H
