
#include  "revbinpermute.h"
#include  "revbinpermute0.h"


// tuning parameter in revbinpermute.h:
#if  ( SYMM == 1 )
#  warning  "FYI:  SYMM == 1  for revbin_permute()"
#else // !=1
#  if  ( SYMM == 2 )
#    warning  "FYI:  SYMM == 2  for revbin_permute()"
#  else  // !=2
#    if  ( SYMM == 4 )
#      warning  "FYI:  SYMM == 4  for revbin_permute()"
#    else
#      error 'SYMM must be 1, 2 or 4  for revbin_permute()'
#    endif //  ( SYMM == 4 )
#  endif //  ( SYMM == 2 )
#endif //  ( SYMM == 1 )

// tuning parameter in revbinpermute0.h:
#if  ( SYMM0 == 2 )
#  warning  "FYI:  SYMM0 == 2  for revbin_permute0()"
#else  // !=2
#  if  ( SYMM0 == 4 )
#    warning  "FYI:  SYMM0 == 4  for revbin_permute0()"
#  else // !=4
#    error 'SYMM0 must be 2 or 4  for revbin_permute0()'
#  endif //  ( SYMM0 == 4 )
#endif //  ( SYMM0 == 2 )




// --------------- UNUSED CODE: ---------------

#ifdef  SECOND_BEST_REVBIN_PERMUTE  // never defined


// tuning parameter:
#define  REVBIN_PERMUTE_UNROLL   1  // 0 or 1 (unroll, default)
#define  REVBIN_PERMUTE0_UNROLL  1  // 0 or 1 (unroll, default)
//
#if  ( REVBIN_PERMUTE_UNROLL==1 )
//#warning 'FYI: REVBIN_PERMUTE_UNROLL activated'
#else
//#warning 'FYI: no REVBIN_PERMUTE_UNROLL'
#endif
//
#if  ( REVBIN_PERMUTE0_UNROLL==1 )
//#warning 'FYI: REVBIN_PERMUTE0_UNROLL activated'
#else
//#warning 'FYI: no REVBIN_PERMUTE0_UNROLL'
#endif


template <typename Type>
void
revbin_permute(Type *f, ulong n)
// put data in revbin order
// self-inverse
{
    if ( n<=2 )  return;

    const ulong nh = (n>>1);
    Type * const f1 = f + n - 1;
    swap(f[1], f[nh]);

    ulong k=2, r=nh;
#if  ( REVBIN_PERMUTE_UNROLL==1 )
    while ( 1  )
#else
    while ( k<nh  )
#endif
    {
        // k even:
        r ^= nh;
        for (ulong m=(nh>>1); !((r^=m)&m); m>>=1)  {;}
   	if ( r>k )
        {
            swap(f[k], f[r]);     // k<nh, r<nh
            swap(f1[-k], f1[-r]); // n-k>nh, n-r>nh
        }
        ++k;

        // k odd:
        r += nh;
        swap(f[k], f[r]);  // k<nh, r>nh
        ++k;

#if  ( REVBIN_PERMUTE_UNROLL==1 )
        if ( k>=nh )  break;  // break always happens here

        // k even:
        r ^= nh;
        r ^= (nh>>1);
        for (ulong m=(nh>>2); !((r^=m)&m); m>>=1)  {;}
   	if ( r>k )
        {
            swap(f[k], f[r]);     // k<nh, r<nh
            swap(f1[-k], f1[-r]); // n-k>nh, n-r>nh
        }
        ++k;

        // k odd:
        r += nh;
        swap(f[k], f[r]);  // k<nh, r>nh
        ++k;
#endif // REVBIN_PERMUTE_UNROLL
    }
}
//============== end =================


template <typename Type>
void
revbin_permute0(Type *f, ulong n)
// put data in revbin order
// version for zero padded data
{
    if ( n<=2 )  return;

    const ulong nh = (n>>1);
    ulong k=2, r=nh;

    f[nh] = f[1];
    f[1] = 0;
#if  ( REVBIN_PERMUTE0_UNROLL==1 )
    while ( 1  )
#else
    while ( k<nh  )
#endif
//    for (ulong k=1,r=0; k<nh;  )
    {
        // k even:
        r ^= nh;
        for (ulong m=(nh>>1); !((r^=m)&m); m>>=1)  {;}
   	if ( r>k )
        {
            swap(f[k], f[r]);
            // f[-k]==0, f[-r]==0
        }
        ++k;

        // k odd: f[k]!=0, f[r]==0
        r += nh;
        f[r] = f[k];
        f[k] = 0;
        ++k;

#if  ( REVBIN_PERMUTE0_UNROLL==1 )
        if ( k>=nh )  break;  // break always happens here

        // k even:
        r ^= nh;
        r ^= (nh>>1);
        for (ulong m=(nh>>2); !((r^=m)&m); m>>=1)  {;}
   	if ( r>k )
        {
            swap(f[k], f[r]);
            // f[-k]==0, f[-r]==0
        }
        ++k;

        // k odd: f[k]!=0, f[r]==0
        r += nh;
        f[r] = f[k];
        f[k] = 0;
        ++k;
#endif // REVBIN_PERMUTE0_UNROLL
    }
}
//============== end =================


#endif //  SECOND_BEST_REVBIN_PERMUTE  // never defined
