#if !defined __ROTATE_H
#define      __ROTATE_H


#include "fxttypes.h"
#include "reverse.h"


template <typename Type>
void
rotate_left(Type *f, ulong n, ulong s)
// rotate towards element #0
{
    if ( s>=n )  s %= n;
    if ( s==0 )  return;

    reverse(f,   s);
    reverse(f+s, n-s);
    reverse(f,   n);
}
//-----------------------


template <typename Type>
void
rotate_right(Type *f, ulong n, ulong s)
// rotate away from element #0
// undefined if s>=n
{
    if ( s>=n )  s %= n;
    if ( s==0 )  return;

    reverse(f,     n-s);
    reverse(f+n-s, s);
    reverse(f,     n);
}
//-----------------------


template <typename Type>
void
rotate(Type *f, ulong n, long s)
// undefined if abs(s)>=n
{
    if ( s>0 )  rotate_right(f,n,(ulong)s);
    else        rotate_left(f,n,(ulong)-s);
}
//-----------------------


#endif // !defined __ROTATE_H
