
#include <math.h>
#include <iostream.h>
#include <iomanip.h>

#include "fxt.h"
#include "fxtaux.h"


void
fillmat(double *f, ulong r, ulong c)
{
    for (ulong tr=0; tr<r; ++tr)
    {
        for (ulong tc=0; tc<c; ++tc)
        {
            *(f++) = tr*1000 + tc;
        }
    }
}
//-------------------------------------------

void
printmat(const double *f, ulong r, ulong c)
{
//    cout << r << " x " << c << ": " << endl;
    for (ulong tr=0; tr<r; ++tr)
    {
        cout.width(3);
        cout << tr << ":  ";
        for (ulong tc=0; tc<c; ++tc)
        {
            cout.width(6);
//            cout.fill('0');
            cout << *(f++) << " ";
        }
        cout << endl;
    }
    cout << endl;
}
//-------------------------------------------

void
mtrans(double *ar, ulong n, ulong &tr, ulong &tc)
{
    revbin_permute(ar, n);  swap(tr,tc);  cout << "FULL REVBIN_PERMUTE for transposition:" << endl;
    printmat(ar, tr, tc);
}
//====================================

void
matrix(double *ar, ulong r, ulong c)
{
    cout << "rows=" << r << "  columns=" << c << endl;

    ulong n = r * c;
    ulong tr = r,  tc = c;
    fillmat(ar, r, c);

    cout << "input data (symbolic format: R00C):" << endl;
    printmat(ar, tr, tc);

    mtrans(ar, n, tr, tc);  // FULL REVBIN_PERMUTE

    cout << "DIT FFTs on revbin_permuted rows (in revbin_permuted sequence), i.e. unrevbin_permute rows:" << endl;
    cout << " (apply weight after each FFT)" << endl;
    for (ulong i=0; i<n; i+=tc)  revbin_permute(ar+i, tc);
    printmat(ar, tr, tc);

    mtrans(ar, n, tr, tc);  // FULL REVBIN_PERMUTE
    cout << "CONVOLUTIONS on rows (don't care revbin_permuted sequence), no reordering. " << endl << endl;
    mtrans(ar, n, tr, tc);  // FULL REVBIN_PERMUTE

    cout << " (apply inverse weight before each FFT)" << endl;
    cout << "DIF FFTs on rows (in revbin_permuted sequence), i.e. revbin_permute rows:" << endl;
    for (ulong i=0; i<n; i+=tc)  revbin_permute(ar+i, tc);
    printmat(ar, tr, tc);

    mtrans(ar, n, tr, tc);  // FULL REVBIN_PERMUTE
}
//====================================

int
main(int argc, char **argv)
{
    ulong ldn = 5;
    if ( argc>1 )  ldn = atol(argv[1]);
    ulong  n = (1<<ldn);

    double *ar = new double[n];   null( ar, n );

    ulong r = n/(1<<(ldn/2));
    ulong c = n/r;
//    swap(r,c);
    matrix(ar, r, c);

    return 0;
}
//====================================

           
