
#include <math.h>
#include <stdlib.h>
#include <assert.h>
#include <iostream.h>
#include <iomanip.h>

#include "fxtaux.h" 
#include "complextype.h"   // Complex


// inluded by other testcodes

//#define max(x,y) (x>y?x:y)
//#define ABS(x)   (x>=0?x:-x)

void
is_delta(double *f, ulong n, ulong i0, double v=1)
{
    for (ulong i=0; i<n; ++i)
    {
        if ( i==i0 )  assert( abs(f[i]-v)<1e-8 );
        else          assert( abs(f[i]  )<1e-8 );
    }
}
// ================= end ==================

void
test_r2c2r(double *f, ulong ldn)
{
    ulong n = 1<<ldn;
    for (ulong k=0; k<n; ++k)
    {
        null(f,n);
        f[k] = 1;
        split_radix_real_complex_fft(f,ldn);
        split_radix_complex_real_fft(f,ldn);
        for (ulong j=0; j<n; ++j)
        {
            if ( fabs(f[j])>1e-8 )
            {
                cout << j << " ";
                assert( j==k );
            }
        }
        cout << endl;
    }
}
// =================== end ===================

//void
//fft_shift(double *fr, double *fi, long n, int is)
//{
//    for (long k=0; k<n; ++k)
//    {
//        double c,s;
//        sincos(is*2*k*PI/n, &s, &c);
//        CMULT(fr[k],fi[k],c,s);
//    }
//}
////-------------------------------------------


void
rand(double *f, long n)
{
//    srand(time(0));

    for (long i=0; i<n; ++i)
    {
	f[i] = (double)rand()*(0.5+0.5/RAND_MAX);
    }
}
//-------------------------------------------


void
rand(double *f, long n, double amin, double amax)
{
    double zmin = -1.0;
    double zmax = +1.0;
    double v = (amax-amin)/(zmax-zmin);

    for (long i=0; i<n; ++i)
    {
        double z = (double)rand()*(1.0/RAND_MAX);
	f[i] = (z-zmin)*v+amin;
    }
}
//-------------------------------------------

void
print(char *bla, double *f, long n)
{
    if ( bla )  cout << "\n" << bla << endl;

    for (long i=0; i<n; ++i)
    {
        cout.precision(14);
	cout << i << ": ";

	if ( fabs(f[i])<1e-12 )  cout << "0.00" << endl;
	else                     cout << f[i] << endl;
    }
}
//-------------------------------------------

void
print(char *bla, Complex *f, long n)
{
    if ( bla )  cout << "\n" << bla << endl;

    for (long i=0; i<n; ++i)
    {
        cout.precision(6);
        cout.width(2);
	cout << i << ": ";

        double fr = f[i].real();
        double fi = f[i].imag();

        double eps = 1e-12;
	if ( fabs(fr)<eps )  fr = 0;
	if ( fabs(fi)<eps )  fi = 0;
        cout << "(" << fr << ", " << fi << ")" << endl;
    }
}
//-------------------------------------------

void
chop_print(double x, double eps)
{
    if ( fabs(x)<eps )  cout << 0;
    else                cout << x;
}
//-------------------------------------------

void
print(char *bla, double *f, double *g, long n)
{
    if ( bla )  cout << "\n" << bla << endl;

    for (long i=0; i<n; ++i)
    {
	cout<< i << ": ";

	if ( fabs(f[i])<1e-12 )  cout << "0.00";
	else                     cout << f[i];
        cout << "  ";
	if ( fabs(g[i])<1e-12 )  cout << "0.00";
	else                     cout << g[i];        
        cout << endl;
    }
}
//-------------------------------------------


double
diff(const double *src, double *dst, long n)
{
    double ret=0;

    for (long i=0; i<n; ++i)
    {
	dst[i] -= src[i];
	ret = max( ret , fabs(dst[i]));
    }

    return ret;
}
//-------------------------------------------


double
maxdiff(const double *a, const double *b, long n, double oldmaxdiff/*=0*/)
{
    double md = oldmaxdiff;
    double ad = fabs(md);
    
    for (long i=0; i<n; ++i)
    {
	double d = b[i]-a[i];

        if ( fabs(d)>ad )
        {
            ad = fabs(d);
            md = d;
        }
    }
    
    return md;
}
//-------------------------------------------
