
#include <math.h>
#include <iostream.h>
#include <iomanip.h>
#include <assert.h>

#include "fxt.h"
#include "fxtaux.h"
#include "graypermute.h"

// walsh/walshXXX.cc:
//void walsh_seq(double *f, ulong ldn);
//void inverse_walsh_seq(double *f, ulong ldn);

void
walsh_test(double *f, ulong ldn)
{
    const ulong n = (1<<ldn);

    revbin_permute(f,n);
//    gray_permute(f,n);
    for (ulong ldm=1; ldm<=ldn; ++ldm) // dit
//    for (ulong ldm=ldn; ldm>=1; --ldm) // dif
    {
        const ulong m = (1<<ldm);
        const ulong mh = (m>>1);
        for (ulong r=0; r<n; r+=m)
        {
            ulong t1 = r;
            ulong t2 = t1+mh;
            double *f1 = f+t1, *f2 = f+t2;
            reverse(f2, mh);
            for (ulong j=0; j<mh; ++j,++t1,++t2)
            {
                double u = f[t1];
                double v = f[t2];
                f[t1] = u + v;
                f[t2] = u - v;
            }
//            reverse(f2, mh);
            reverse(f1, mh);
        }
    }
//    revbin_permute(f,n);
}
// ================= end ==================


void
walsh_test2(double *f, ulong ldn)
{
    const ulong n = (1<<ldn);

//    revbin_permute(f,n);
//    gray_permute(f,n);
//    for (ulong ldm=1; ldm<=ldn; ++ldm) // dit
    for (ulong ldm=ldn; ldm>=1; --ldm) // dif
    {
        const ulong m = (1<<ldm);
        const ulong mh = (m>>1);
        for (ulong r=0; r<n; r+=m)
        {
            ulong t1 = r;
            ulong t2 = t1+mh;
            double *f1 = f+t1, *f2 = f+t2;
            reverse(f2, mh);
            for (ulong j=0; j<mh; ++j,++t1,++t2)
            {
                double u = f[t1];
                double v = f[t2];
                f[t1] = u + v;
                f[t2] = u - v;
            }
//            reverse(f2, mh);
            reverse(f1, mh);
        }
    }
    revbin_permute(f,n);
}
// ================= end ==================


void
prsgn(double *f, ulong n)
{
    int s1 = sign(f[0]);
    int seq = 0;
    cout << "[";
    for (ulong k=0; k<n; ++k)
    {
        int s2 = sign(f[k]);
        if ( s1!=s2 )  seq++;
        s1 = s2;
        cout << (f[k]>0 ? '*' : ' ' );
        if ( k<n-1 ) cout << ' ';
    }
    cout << "] ";
    cout << "(" << setw(2) << seq << ")";
//    cout << endl;
}
//===========================

int
main(int argc, char **argv)
{
    ulong ldn = 4;
    if ( argc>1 )  ldn = atol(argv[1]);
    ulong  n = (1<<ldn);

    double *ar = new double[n];   null( ar, n );
    double *fr = new double[n];   null( fr, n );

    for (ulong x=0; x<n; ++x)
    {
        null(ar, n);
        ar[x] = 1;
        copy(ar,fr,n);

//        dif2_walsh_wak(ar,ldn);
//        dit2_walsh_pal(fr,ldn);

//        walsh_wal0(ar,ldn);
        dif2_walsh_wal(ar,ldn);
        walsh_circ(fr,ldn);

//        inverse_walsh_seq(ar,ldn);
//        walsh_seq(fr,ldn);
//        walsh_seq(ar,ldn);  is_delta(ar,n,x,n);

//        walsh_test(ar,ldn);
//        walsh_test2(fr,ldn);

//        print("",fr,n);

        cout.width(2);  cout << x << ":";

        cout << " ";  prsgn(ar,n);
        cout << "  ";
        cout << " ";  prsgn(fr,n);

        cout << endl;
    }

    return 0;
}
//===========================
