
#include "copy.h"

#include <math.h> // pow()


void
slow_zt(double *f, ulong n, double z)
//
// (slow) z-transform
//
{
    double *res = new double[n];

    const double ph0 = 1.0/n;

    for (ulong w=0; w<n; ++w)
    {
        double sum = 0.0;
        for (ulong k=0; k<n; ++k)
	{
            double t = pow(z, ph0*k*w);
            sum += f[k] * t;
	}

        res[w] = sum;
    }

    copy(res, f, n);

    delete [] res;
}
// ================== end ====================
