
#include "fxt.h"
#include "fxtaux.h" 

#include <iostream.h>

#define  CHECK() \
 for (ulong j=0; j<n; ++j) \
  if ( abs(fc[j]-gc[j]) > 1e-8 ) \
  { cout << "***ERROR***" << endl;  exit(3); }

#define  TEST_C_FFT(NAME) \
 cout << "+ " << #NAME << "(Complex *, ulong ldn, int is)" << endl; \
 copy(ac,gc,n); \
 NAME(gc, ldn, is); \
 CHECK()

#define  TEST_RI_FFT(NAME) \
 cout << "+ " << #NAME << "(double *, double *, ulong ldn, int is)" << endl; \
 copy(ac,gc,n); \
 complex_to_real_imag(gc, n); \
 NAME(gr, gi, ldn, is); \
 real_imag_to_complex((double *)gc, (double *)gc+n, n); \
 CHECK()


int
main(int argc, char **argv)
{
    ulong minldn = 0, maxldn = 9;
    int rep = 1;  // PARAMETER: # of repetitions of all test

    ulong n = 1<<maxldn;
    Complex ac[n], fc[n], gc[n];
    
    for (int r=0; r<rep; ++r)
    {
        cout << "+++ r=" << r << " ... " << endl;

        for (ulong i=0; i<n; ++i)  ac[i] = Complex(white_noise(), white_noise());

        for (ulong ldn=minldn; ldn<=maxldn; ++ldn)
        {
            n = 1<<ldn;
            cout << "++ ldn=" << ldn << "  n=" << n << " :" << endl;

            for (int is=-1; is<=1; is+=2)
            {
                cout << " + is=" << is << endl;
                copy(ac, fc, n);
                fht_fft(fc,ldn,is);

                TEST_C_FFT( split_radix_fft );
                TEST_C_FFT( matrix_fft );

                double *gr = (double *)gc;
                double *gi = gr + n;
                TEST_RI_FFT( fht_fft );
                TEST_RI_FFT( split_radix_fft );
                TEST_RI_FFT( matrix_fft );
                TEST_RI_FFT( dif4_fft );
                TEST_RI_FFT( dit4_fft );
                TEST_RI_FFT( dif2_fft );
                TEST_RI_FFT( dit2_fft );
            }
        }
    }

    cout << "OK." << endl;
    return 0;
}
//===========================================
