
#include "copy.h" // copy()
#include "graypermute.h"
#include "revbinpermute.h"

#include "fxt.h" // dit2_walsh_wak()


void
walsh_wak0(double *f, ulong ldn)
// transform wrt. to walsh-kronecker basis (wak-functions)
// version for zero padded data
{
    if ( ldn==0 )  return;

    ulong n = (1<<(ulong)ldn);
    dit2_walsh_wak(f,ldn-1);
    copy(f, f+n/2, n/2);
}
// ============= end ===============


void
walsh_wal0(double *f, ulong ldn)
//
// transform wrt. to walsh-kaczmarz basis (wal-functions)
// the wal functions are sequency- ordered
//
{
    const ulong n=(1<<ldn);
    walsh_wak0(f,ldn);
    revbin_permute(f,n);
    inverse_gray_permute(f,n);
}
// ================= end ==================


void
walsh_pal0(double *f, ulong ldn)
// transform wrt. to walsh-paley basis (pal-functions)
// version for zero padded data
{
    if ( ldn==0 )  return;

    ulong n = (1<<(ulong)ldn);
    walsh_wak0(f, ldn);
    revbin_permute(f, n);
}
// ============= end ===============
