
#include <math.h>

#include "fxt.h"  // needs fft
#include "misc.h"  // multiply()


#define  FFT(fr,fi,ldn,is)  fht_fft(fr,fi,ldn,is)  
#define  is  (+1)

void
harmonic_wavelet(double *fr, double *fi, ulong ldn)
// harmonic wavelet transform
// cf. crandall, "topics in advanced
// scientific computation", p.177
// here real input is not assumed
{
    ulong n = (1<<ldn);
    if ( n<4 )  return;

    FFT(fr,fi,ldn,is);
    multiply(fr,n,1.0/sqrt(n));
    multiply(fi,n,1.0/sqrt(n));

    for (ulong ldm=1; ldm<=ldn-1; ++ldm)
    {
        ulong m = (1<<ldm);  // m=2,4,8,...,n/2

        FFT(fr+m,fi+m,ldm,is);
        multiply(fr+m,m,1.0/sqrt(m));        
        multiply(fi+m,m,1.0/sqrt(m));        
    }
}
// ============= end  ===============

void
inverse_harmonic_wavelet(double *fr, double *fi, ulong ldn)
{
    ulong n = (1<<ldn);
    if ( n<4 )  return;

    for (ulong ldm=ldn-1; ldm>=1; --ldm)
    {
        ulong m = (1<<ldm);  // m=n/2,n/4,...,4,2
        FFT(fr+m,fi+m,ldm,-is);
        multiply(fr+m,m,1.0/sqrt(m));        
        multiply(fi+m,m,1.0/sqrt(m));        
    }

    FFT(fr,fi,ldn,-is);
    multiply(fr,n,1.0/sqrt(n));
    multiply(fi,n,1.0/sqrt(n));
}
// ============= end  ===============

