
#include "fxt.h"


#define  FFT(fr,fi,ldn,is)  fht_fft(fr,fi,ldn,is)


void
weighted_fft(double *fr, double *fi, ulong ldn, int is, double w)
{
    ulong n = (1<<ldn);
    fourier_shift(fr, fi, n, w);
    FFT(fr, fi, ldn, is);
}
//============= end ============


void
weighted_inverse_fft(double *fr, double *fi, ulong ldn, int is, double w)
//
// inverse of above iff signs of both w _and_ is are changed
//
{
    ulong n = (1<<ldn);
    FFT(fr, fi, ldn, is);
    fourier_shift(fr, fi, n, w);
}
//============= end ============

