#if !defined __AUXDOUBLE_H
#define      __AUXDOUBLE_H

#include <math.h>
#include <stdlib.h>  // random()

#include "fxttypes.h"     // for ulong
#include "complextype.h"  // for type Complex

// auxil/auxdouble.cc:
double rnd01();
double white_noise();
double pythag(double a, double b);
double extr3_estimate(const double *f, double *xvalp=0);
double sinc(double x);
void sumdiff(double *we, double *wo, ulong n);
void sumdiff_05(double *we, double *wo, ulong n);

//void   multiply2(double *f, ulong n, int ex);
double norm(const double *f, ulong n);
void   normalize(double *f, ulong n, double v=1.0);
double scalar_product(const double *f, const double *g, ulong n);
double mean(const double *f, ulong n);
double subtract_mean(double *f, ulong n, double *dst=0);
double sigma(const double *f, ulong n, double *mp=NULL);
void   mean_sigma(const double *f, ulong n, double *mp, double *sp);
void   smooth(double *f, ulong n, ulong m=1);
double rms_diff(const double *f, const double *g, ulong n);
double rms_diff(const Complex *f, const Complex *g, ulong n);
ulong *histogram(const double *f, ulong n, ulong nbox, ulong *hh=NULL);

void welch_win(double *f, ulong n);

void ri_multiply(const double *fr, const double *fi,
                 double *gr, double *gi, ulong n);

// jj_end_autodoc

// auxil/auxprint.cc:
void print(const char *bla, const double *f, ulong n, double eps=0.0);
void print_twodim(const char *bla, const double *f, ulong r, ulong c, double eps=0.0);

void c_print(const char *what, const Complex *c, long n, double eps=0.0);
void ri_print(const char *bla, const double *fr, const double *fi, long n, double eps=0.0);

void approx_eq(const double *f, const double *g, uint n, const char *bla, double eps=1e-12);
void approx_eq(const Complex *f, const Complex *g, uint n, const char *bla, double eps=1e-12);


// auxil/sincostb.cc:
void make_sincos_table(ulong n, ulong m, double **s, double **c);


// auxil/resample.cc:
ulong resample_sinc(const double *a, ulong an, double af, double *b, double bf, ulong bn);
ulong resample_linear(const double *f, ulong nf, double v, double *g, ulong ng);
ulong sample_up_linear(const double *f, ulong nf, double v, double *g, ulong ng);
ulong sample_down_linear(const double *f, ulong nf, double v, double *g, ulong ng);


#endif  // !defined __AUXDOUBLE_H
