#if !defined __MISC_H
#define      __MISC_H


#include "fxttypes.h"
#include "copy.h"


template <typename Type>
Type
get_sum(const Type *f, ulong n)
// return sum of array f[]
{
    Type s = 0;
    while ( n-- )  s += f[n];
    return s;
}
//-----------------------


template <typename Type>
void
diff(Type *f, ulong n, ulong j=1)
// first difference (applied j times) of f[]
{
    if ( j>=n )
    {
        null(f,n);
        return;
    }

    for (ulong k=1; k<=j; ++k)
    {
        for (ulong i=1; i<=n-k; ++i)
        {
            f[i-1] = f[i] - f[i-1];
        }
        f[n-k] = 0;
    }
}
//-----------------------


template <typename Type>
void
negate(Type *f, ulong n)
// negate f[]
{
    while ( n-- )  f[n] = -f[n];
}
//-----------------------


// multiply array by s:
template <typename Type>
void
multiply(Type *f, ulong n, Type s)
// multiply f[] by s
{
    while ( n-- )  f[n] *= s;
}
//-----------------------


template <typename Type>
void
apply_func(Type *f, ulong n, Type (*func)(Type))
// apply function func to each element of f[]
{
    while ( n-- )  f[n] = func(f[n]);
}
//-----------------------


#endif // !defined __MISC_H
