#if !defined __ARRAY2D_H
#define      __ARRAY2D_H

#include "fxttypes.h"
#include "auxtempl2d.h"
#include "auxbit.h"  // ldq()
//#include "scale2d.h"

// whether to make range checks on index of requested row
#define  ROW_ASSERT  0  // 0 (fast) or 1 (to catch acces beyond size)

#if  ( ROW_ASSERTS==1 )
// array2d.cc:
void row_assert(ulong r, ulong nr);
#endif

template <typename Type>
class array2d
{
public:
    array2d(ulong _nr, ulong _nc, Type *_f=0);
    array2d(ulong _nr, ulong _nc, Type **_rowp);
    ~array2d();

#if  ( ROW_ASSERTS==1 )
    Type *row(ulong r) const  { assert_row(r,nr);  return rowp[r]; }
#else
    Type *row(ulong r) const  { return rowp[r]; }
#endif

    Type **get_rowp()  const  { return rowp; }

    void null()  { ::null(rowp,nr,nc); }
    void min_max(Type *mi, Type *ma)  const  { ::min_max((const Type **)rowp,nr,nc, mi,ma); }
    void linear_scale(Type mi, Type ma, Type nmi, Type nma)  { ::linear_scale(rowp,nr,nc, mi,ma,nmi,nma); }
    void linear_scale(Type nmi, Type nma)  { ::linear_scale(rowp,nr,nc, nmi,nma); }
    void log_scale(double xi, double xa, Type nma)  { ::log_scale(rowp,nr,nc, xi,xa,nma); }

    void apply_func(Type (*func)(Type)) { ::apply_func(rowp,nr,nc, func); }

    void shift_up(ulong r)  { ::shift_up(rowp,nr,nc, r); }
    void shift_down(ulong r)  { ::shift_down(rowp,nr,nc, r); }
    void shift_vert(long r)  { ::shift_vert(rowp,nr,nc, r); }
    void shift_left(ulong r)  { ::shift_left(rowp,nr,nc, r); }
    void shift_right(ulong r)  { ::shift_right(rowp,nr,nc, r); }
    void shift_horiz(long r)  { ::shift_horiz(rowp,nr,nc, r); }
    void shift(long vert, long horiz)  { ::shift(rowp,nr,nc, vert,horiz); }

    void reverse_vert()  { ::reverse_vert(rowp,nr,nc); }
    void reverse_horiz()  { ::reverse_horiz(rowp,nr,nc); }

    void rotate_up(ulong r)  { ::rotate_up(rowp,nr,nc, r); }
    void rotate_down(ulong r)  { ::rotate_down(rowp,nr,nc, r); }
    void rotate_vert(long r)  { ::rotate_vert(rowp,nr,nc, r); }
    void rotate_left(ulong r)  { ::rotate_left(rowp,nr,nc, r); }
    void rotate_right(ulong r)  { ::rotate_right(rowp,nr,nc, r); }
    void rotate_horiz(long r)  { ::rotate_horiz(rowp,nr,nc, r); }
    void rotate(long vert, long horiz)  { ::rotate(rowp,nr,nc, vert,horiz); }
    void zero2center()  { ::zero2center(rowp,nr,nc); }

    void transpose()  { ::transpose(rowp,nr,nc); }


    // --- data:
public:
    const ulong nc, nr, n;
    const ulong ldnc, ldnr;

private:
    Type **rowp;
    bool myrowpq;
    Type *f;
    bool myfq;
};
//---------------------------------------------


template <typename Type>
array2d<Type>::array2d(ulong _nr, ulong _nc, Type *_f=0)
    : nc(_nc), nr(_nr), n(_nc*_nr),
      ldnc(ldq(_nc)), ldnr(ldq(_nr))
{
    if ( 0!=_f )
    {
        f = _f;
        myfq = false;
    }
    else
    {
        f = new Type[n];
        myfq = true;
    }

    rowp = new Type*[nr];
    myrowpq = true;

    rowp[0] = f;
    for (ulong i=1; i<nr; ++i)  rowp[i] = rowp[i-1] + nc;
}
//-----------------------

template <typename Type>
array2d<Type>::array2d(ulong _nr, ulong _nc, Type **_rowp)
    : nc(_nc), nr(_nr), n(_nc*_nr),
      ldnc(ldq(_nc)), ldnr(ldq(_nr))
{
    rowp = _rowp;
    myrowpq = false;

    f = rowp[0];
    myfq = false;
}
//-----------------------

template <typename Type>
array2d<Type>::~array2d()
{
    if ( myrowpq )  delete [] rowp;

    if ( myfq )  delete [] f;
}
//-----------------------


#if  ( ROW_ASSERTS==1 )
template <typename Type>
Type *
array2d<Type>::row(ulong r) const
{
    if ( r>=nr || (long)r<0 )
    {
        cerr << __PRETTY_FUNCTION__ << endl;    
        cerr << " r=" << r << "  (nr=" << nr << ")" << endl;
        assert( r<nr );
        assert( (long)r>=0 );
    }
    return rowp[r];
}
//-----------------------
#else
// inline member function in array2d.h
#endif


template <typename Type1, typename Type2>
void
copy(const array2d<Type1> &src, array2d<Type2> &dst,
     ulong coff=0, ulong roff=0)
{
    ::offset_copy((const Type1 **)src.get_rowp(), src.nr, src.nc,
                  dst.get_rowp(), dst.nr, dst.nc,
                  coff, roff);
}
//-----------------------


#endif  // !defined __ARRAY2D_H
