#if !defined __COPY2D_H
#define      __COPY2D_H

#include "fxttypes.h"
#include "copy.h"


template <typename Type>
void
null(Type **f, ulong nr, ulong nc)
{
    while ( nr-- )  null(f[nr],nc);
}
//-----------------------


template <typename Type>
void
fill(Type **f, ulong nr, ulong nc, Type v)
{
    while ( nr-- )  fill(f[nr],nc,v);
}
//-----------------------


template <typename Type1, typename Type2>
void
offset_copy(const Type1 **src, ulong nrs, ulong ncs,
            Type2 **dst, ulong nrd, ulong ncd,
            ulong coff=0,
            ulong roff=0)
// copy (as much data as possible)
// src[i+coff,j+roff] --> dst[i,j]
{
    if ( roff>=nrs )  return;
    if ( coff>=ncs )  return;
//    if ( roff>=nrd )  return;
//    if ( coff>=ncd )  return;

    ulong clen = min(ncs-coff, ncd); // > 0
    ulong rlen = min(nrs-roff, nrd); // > 0
    for (ulong r=0;  r<rlen;  ++r)
    {
        copy(src[r+roff]+coff, dst[r], clen);
    }
}
//-----------------------

#endif // !defined __COPY2D_H
