#if !defined __TRANSPOSE_H
#define      __TRANSPOSE_H

#include "fxttypes.h"
#include <assert.h>


template <typename Type>
void
transpose(Type **f, ulong nr, ulong nc)
// currently only for nr==nc
{
    assert( nr==nc );  // jjnote: todo: transpose for nr!=nc
    for (ulong r=0; r<nr; ++r)
    {
        for (ulong c=r+1; c<nc; ++c)
        {
            // swap(f[r][c], f[c][r]):
            Type  t = f[r][c];
            f[r][c] = f[c][r];
            f[c][r] = t;
        }
    }
}
//-----------------------


#endif // !defined __TRANSPOSE_H
