
//#include <assert.h>

#include "fxt.h"
#include "fxtdefs.h"


void
fht_fft_convolution(double *f, double *g, ulong ldn)
// g[] = f[] (*) g[]
{
//    assert( f!=g );

    fht_real_complex_fft(f,ldn);
    fht_real_complex_fft(g,ldn);

    fft_convolution_core1(f,g,ldn);

    fht_complex_real_fft(g,ldn);
}
//============ end ===============


void
split_radix_fft_convolution(double *f, double *g, ulong ldn)
// g[] = f[] (*) g[]
{
//    assert( f!=g );

    split_radix_real_complex_fft(f,ldn);
    split_radix_real_complex_fft(g,ldn);

    fft_convolution_core1(f,g,ldn);

    split_radix_complex_real_fft(g,ldn);
}
//=========================== end =================


void
fht_fft_convolution0(double *f, double *g, ulong ldn)
// g[] = f[] (*) g[]
{
//    assert( f!=g );

    fht_real_complex_fft0(f,ldn);
    fht_real_complex_fft0(g,ldn);

    fft_convolution_core1(f,g,ldn);

    fht_complex_real_fft(g,ldn);
}
//============ end ===============


void
split_radix_fft_convolution0(double *f, double *g, ulong ldn)
// g[] = f[] (*) g[]
{
//    assert( f!=g );

    split_radix_real_complex_fft0(f,ldn);
    split_radix_real_complex_fft0(g,ldn);

    fft_convolution_core1(f,g,ldn);

    split_radix_complex_real_fft(g,ldn);
}
//=========================== end =================



void
fft_convolution_core1(double *f, double *g, ulong ldn, double v/*=0.0*/)
{
    const ulong n  = (1<<ldn);
    const ulong nh = n/2;

    if ( v==0.0 )  v = 1.0/n;

    g[0]  *= f[0] * v;
    g[nh] *= f[nh] * v;

    for (ulong i=1,j=n-1; i<nh; ++i,--j)
    {
        CMULT_N(f[i], f[j], g[i], g[j], v);
    }
}
//================== end =============


void
fft_convolution_core2(double *f, double *g, ulong ldn, double v/*=0.0*/)
{
    const ulong n  = (1<<ldn);
    const ulong nh = n/2;

    if ( v==0.0 )  v = 1.0/n;

    g[0]  *= f[0] * v;
    g[nh] *= f[nh] * v;

    for (ulong i=1,j=nh+1; i<nh; ++i,++j)
    {
        CMULT_N(f[i], f[j], g[i], g[j], v);
    }
}
//================== end =============
