
// MACHINE GENERATED FILE, DO NOT EDIT !
// this file was generated from fhtcnvl.cc
#include "complextype.h"

#include "fxt.h"
#include "fxtdefs.h"  // FHT_MUL()

// tuning parameter:
#define  FHT_CONVOLUTION_VERSION  0  // 0 (default) or 1
//
#if  ( FHT_CONVOLUTION_VERSION==0 )
#warning 'FYI fht_convolution(Complex *, ulong) using revbin_permuted_core'
#else
#warning 'FYI fht_convolution(Complex *, ulong) using normal core'
#endif


void
fht_convolution(Complex *x, Complex *y, ulong ldn)
// y[] = x[] (*) y[]
{
#if  ( FHT_CONVOLUTION_VERSION==0 )
    split_radix_dif_fht_core(x, ldn);
    split_radix_dif_fht_core(y, ldn);
    fht_convolution_revbin_permuted_core(x, y, ldn);
    split_radix_dit_fht_core(y, ldn);
#else
    fht(x, ldn);
    fht(y, ldn);
    fht_convolution_core(x, y, ldn);
    fht(y, ldn);
#endif
}
//================== end =================


void
fht_convolution0(Complex *x, Complex *y, ulong ldn)
// y[] = x[] (*) y[]
// version for zero padded data (i.e. linear convolution)
{
    fht0(x, ldn);
    fht0(y, ldn);
    fht_convolution_core(x, y, ldn);
    fht(y, ldn);
}
//================== end =================


void
fht_convolution_core(Complex *x, Complex *y, ulong ldn,
                     double v/*=0.0*/) // jjkeep
// v!=0.0 chooses alternative normalization
{
    const ulong   n = (1<<ldn);

    if ( v==0.0 )  v = 1.0/n;

    y[0]  *=  (v * x[0]);
    if ( n<2 )  return;

    const ulong  nh = n/2;
    y[nh] *= (v * x[nh]);

    v *= 0.5;
    for (ulong i=1,j=n-1; i<nh; i++,j--)
    {
        FHT_MUL(x[i], x[j], y[i], y[j], v);
    }

}
//================== end =================


void
fht_convolution_revbin_permuted_core(Complex *f, Complex *g, ulong ldn,
                               double v/*=0.0*/)  // jjkeep
//
// as fht_convolution_core() with data access in revbin order
//
{
    const ulong n = (1<<ldn);

    if ( v==0.0 )  v = 1.0/n;
    f[0] *= (v * f[0]);  // == [0]
    if ( n>=2 )  f[1] *= (v * f[1]); // == [nh]

    if ( n<4 )  return;

    v *= 0.5;
    const ulong nh = (n>>1);

    ulong r=nh, rm=n-1;
    FHT_MUL(f[r], f[rm], g[r], g[rm], v);

    ulong k=2, km=n-2;
    while ( k<nh  )
    {
        // k even:
        rm -= nh;
        ulong tr = r;
        r^=nh;  for (ulong m=(nh>>1); !((r^=m)&m); m>>=1)  {;}
        FHT_MUL(f[r], f[rm], g[r], g[rm], v);
        --km;
        ++k;

        // k odd:
        rm += (tr-r);
        r += nh;
        FHT_MUL(f[r], f[rm], g[r], g[rm], v);
        --km;
        ++k;
    }
}
//============== end =================
