
#include <math.h>
#include <iostream.h>
#include <stdlib.h>  // atol()

#include "fxt.h"
#include "fxtaux.h"

//#include "../test/testaux.cc"

void fft_(Complex *);

int
main(int argc, char **argv)
{
    if ( argc<=2 )  exit(-1);
    ulong ldn = atol(argv[1]);
    ulong n = (1<<ldn);

    int is = atol(argv[2]);

    Complex f[n], g[n];
//    null(f,n);  f[1] = 1;
    for (ulong i=0; i<n; ++i)  f[i] = Complex(white_noise(), 0.271*i + white_noise());
    copy(f, g, n);

    fft_(f);
    split_radix_fft(g, ldn, is);
    multiply((double *)f, 2*n, 1.0/sqrt(n));
    multiply((double *)g, 2*n, 1.0/sqrt(n));

    double err = rms_diff((double *)f, (double *)g, 2*n);
    cout << "ldn=" << ldn << "  n=" << n << "  err=" << err << endl;

//    approx_eq((double *)f, (double *)g, 2*n, "");

    if ( err>1e-8)  return -1;
    else            return  0;
}
// ===================== end =====================
