
#include "fxt.h"
#include "fxtaux.h"
#include "permute.h"
#include "graypermute.h"
#include "jjassert.h"

#include <iostream.h>
#include <iomanip.h>

#define  TT(x)  { cerr << "// " << #x << " for n=" << n << endl;  x; }

const int pc = 1;  // whether to print code

const long nada = -0x7badcafe;  // must be negative
const long mask = (1<<(BITS_PER_LONG-1));

inline long mk_el(long x)   { return  x ^ mask; }
inline long mk_ldr(long x)  { return  x | mask; }
inline int  is_ldr(long x)  { return (x & mask ? 1 : 0); }

void
base2print(ulong x, ulong ldn)
{
    ulong m = 1<<ldn;
    ulong u = x;
    for (ulong j=0;  j<=ldn;  ++j, m>>=1)  cout << ((u&m)? '1' : '.');
}
// =========================


void
print_cycles(long *cyc)
{
    cout << "===== CYCLES: ====="<< endl;
    ulong i;
    ulong c = 0;
    for (i=0;  cyc[i]!=nada;  ++i)
    {
        long z = cyc[i];
        if ( is_ldr(z) )  // new cycle
        {
            if ( i )  cout << ")" << endl;
            z = mk_el(z);
            cout << "#" << (++c) << ":   ";
            cout << "(" << setw(3) << z;
        }
        else
        {
            cout  << ","<< setw(3) << z;
        }
    }
    if ( i )  cout << ")" << endl;
    cout << endl;
}
// =========================


void
print_code(long *cyc)
{
    cout << "// ===== CODE: (to stderr) ====="<< endl;
    ulong i;
    for (i=0;  cyc[i]!=nada;  ++i)
    {
        long ct;
        long z = cyc[i];
        if ( is_ldr(z) )  // new cycle
        {
            ct = 0;
            if ( i )  cerr << "=t; }" << endl;
            z = mk_el(z);
            cerr << "{ Type t=f[" << z << "]; ";
            cerr << "f[" << z << "]";
        }
        else
        {
            cerr  << "=f[" << z << "];";
            ++ct;
            if ( !(ct&3) )  cerr << endl;
            cerr << " f[" << z << "]";
        }
    }
    if ( i )  cerr << "=t; }" << endl;
    cerr << endl;
}
// =========================


void
invert_cycles(long *cyc)
{
    ulong i = 0;
    while ( cyc[i]!=nada )
    {
        ulong j = i;
        do
        {
            ++j;
        }
        while ( !is_ldr(cyc[j]) );

        cyc[i] = mk_el(cyc[i]);
        reverse(cyc+i, j-i);
        cyc[i] = mk_el(cyc[i]);
        i = j;
    }
}
// =========================


ulong
get_cycle_leaders(const long *cyc, long *x, ulong n)
{
    ulong k = 0,  nl = 0;
    while ( cyc[k]!=nada )
    {
        if ( is_ldr(cyc[k]) )
        {
            x[nl] = mk_el(cyc[k]);
            ++nl;
        }
        ++k;
    }
    return nl;
}
// =========================


void
print_leaders(long *cyc, ulong ldn)
{
    cout << "===== LEADERS: ====="<< endl;
    long ldr = 0, lastldr, lastel = 0;
    ulong i = 0, ct = 0, x = 0;
    for (i=0;  cyc[i]!=nada;  ++i)
    {
//        if ( one_bit_q((ulong)i) )  cout << "----" << endl;  // newline at 2**k
        long z = cyc[i];
        if ( is_ldr(z) )  // new cycle
        {
            ++ct;
            cout.width(3); cout << ct << ":  "; 

            lastldr = ldr;
            ldr = mk_el(z);
//            cout << endl << ldr << '*';
            cout.width(3); cout << ldr << "=";  base2print(ldr, ldn);
            x = lastldr ^ ldr;
            cout << "  ^="; base2print(x,ldn); cout << "="; cout.width(3); cout << x; 
            cout << "   "; cout.width(3); cout << lastel << "="; base2print(lastel,ldn);
            cout << endl;
        }
        else
        {
            lastel = z;
//            cout << z;
//            cout << '.';
        }
    }
    cout << endl;
}
// =========================


void
prseq(long *f, long *x, ulong n)
{
    cout << endl;
    ulong ldn = ld(n);
    long ci = 0;
    for (ulong i=0; i<n; ++i)
    {
        ulong uf = (ulong)f[i];
        if ( i == 1UL<<ld(i) )  cout << endl;
//        else continue;

        cout << "  ";
        cout.width(3); cout << i << " ";
//        base2print(i, ldn);
        cout << ": ";

        cout.width(3); cout << f[i] << "=";  base2print(uf,ldn);

        int cq = 0;
        if ( x )
        {
            cout << setw(3) << x[i]; // << "#";
            if ( ci<x[i] )  { ci = x[i];  cq = 1; cout << "#"; }  // cycle start
            else cout << ' ';
        }

        if ( cq )
        {
            cout << "       ";
            cout << setw(3) << revbin(i, ld(n)) << "   ";
            cout << setw(3) << graycode(i) << "  ";
            cout << setw(3) << inverse_graycode(i) << "  ";
        }

        cout << endl;
    }
    cout << endl;
}
// =========================

void
tower(long *f, ulong ldx)
{
    const ulong n = 1<<ldx;

    for (ulong ldm=ldx; ldm>=1; ldm--) // dif (gray, inverse_evenodd)
//    for (ulong ldm=1; ldm<=ldx; ldm++) // dit (inverse_gray, evenodd)
    {
        ulong m = 1<<ldm;
        for (ulong r=0; r<n; r+=m)
        {
            revbin_permute(f+r, m);
        }
    }
}
// =========================


int
main(int argc, char **argv)
{
//    x_tab(9); // exit(999);

    ulong n = 16;
    if ( argc>1 )  n = atol(argv[1]);
    ulong ldn = ld(n);
    if ( (long)n<0 )
    {
        ldn = -(long)n;
        n = 1<<ldn;
    }
    cout << "ldn=" << ldn << "  n=" << n << endl;

    ulong a1 = 3;
    if ( argc>2 )  a1 = atol(argv[2]);


    long *y = new long[n];  // permuted indices
    fill_seq(y, n);

    TT( revbin_permute(y, n) );
    TT( reverse(y, n) );
//    TT( revbin_permute(y, n/2);  revbin_permute(y+n/2, n/2); );
//    TT( gray_permute(y, n) );

//    TT( tower(y, ldn); );
//    TT( tower(y, ldn-1);  tower(y+n/2, ldn-1); );

//    prseq(y,0,n);  exit(99);


    // ++++++++++ study permutation: ++++++++++
    long *x = new long[n];  // starts of cycles
    null(x,n);

    long *cyc = new long[n+1]; // cycles (one extra for safe ending)
    fill(cyc, n+1, nada);
    ulong cyci = 0;

    const int PRT = 1;  // whether to print during cycle analysis

    cout << endl << "// ===== ANALYSING CYCLES: =====" << endl;
    ulong c = 0;  // number of current cycle
    ulong opct = 0;  // # of ops
    ulong fixct = 0;  // # of fixed points
    ulong clen;  // length of current cycle
    ulong maxclen = 0, minclen = n+1;  // min/max cycle length
    long maxidx; // max index in cycle
    for (ulong i=0; i<n; ++i)
    {
        if ( PRT==1 )  if ( i == 1UL<<ld(i) )  cout << endl;  // newline at 2**k

        if ( x[i] )  continue;  // ... from earlier cycle

        if ( (long)i==y[i] )
        {
            ++fixct;
            continue;  // ... element is fixed point
        }

        if ( PRT==1 )  base2print(i,ldn);
        if ( PRT==1 )  cout << "=(" << setw(3) << i;  // PRT

        ++c;
        x[i] = c;
        clen = 1;

        cyc[cyci] = mk_ldr((long)i);  // record cycle leader (negative)
        maxidx = cyc[cyci];
        ++cyci;

        ulong k, j;
        for (j=i, k=y[j];  !x[k];  j=k, k=y[k])  // k = successor(j)
        {
            x[k] = c;
            ++opct;
            ++clen;
            if ( PRT==1 )  cout  << ","<< setw(3) << y[j];

            cyc[cyci] = y[j];  // record cycle members
            long el = cyc[cyci];
            if ( maxidx<el )  maxidx = el;  // update maxidx
            ++cyci;
        }

        ++opct;

        if ( PRT==1 )
        {
            cout  << ")";
            cout << "  #" << c << "=" << clen;
            ulong z = (ulong)maxidx;
//            z ^= ((2<<ld(z))-1);
            cout << "   <=" << z << "=";
            base2print(z, ld(z));
            cout << endl;
        }

        jjassert( i!=j );  // trivial cycles ?  can't be !

        if ( clen>maxclen )  maxclen = clen;
        if ( (clen!=1) && (clen<minclen) )  minclen = clen;
    }
    if ( minclen>n )  minclen = maxclen;
    cout << endl;


    // ... print results:
    cout << "opct=" << opct << "   fixct=" << fixct << endl;
    jjassert( n==opct+fixct );
    cout << "min_cycle_len=" << minclen << endl;
    cout << "max_cycle_len=" << maxclen << endl;
    cout << "# cycles =" << c << endl;

    const char wow[] = "+++++++++++++++++  ";
    if ( maxclen==2 )  cout << wow << "--- INVOLUTION ---" << endl;
    if ( c==0 )  cout << wow << "--- IDENTITY ---" << endl;
    else if ( minclen==maxclen )  cout << wow << "--- ONE CYCLE LENGTH ---" << endl;
    if ( c==1 )  cout << wow << "--- ONE CYCLE ---" << endl;



//    print_cycles(cyc);

    print_leaders(cyc, ldn);

//    ulong nl = get_cycle_leaders(cyc, x, n);
//    cout << "cycle leaders:" << endl;
//    for (ulong k=0,ldk=0; k<nl; ++k)
//    {
//        ulong ldx = ld((ulong)x[k]);
//
//        if ( ldx>ldk )  { ldk=ldx; cout<<"-----------"<<endl; }
//        cout.width(3);  cout << x[k] << "  ";
//        if ( k )
//        {
//            ulong z = (x[k]-(1UL<<ldx));
//            cout.width(3);
//            cout << z;
//            cout << "   " << (x[k]-x[k-1]);
//            if ( one_bit_q(z) )  cout<<endl;
//        }
//        cout << endl;
//    }


//    prseq(y,x,n);

    print_code(cyc);
    cout << " inverting cycles ... " << endl;
    invert_cycles(cyc);
    print_code(cyc);


    return 0;
}
//===========================================
