
#include <math.h>
#include <iostream.h>

#include "fxt.h"
#include "fxtaux.h"
#include "fxtdefs.h"  // SUMDIFF, CSQR, CMULT
#include "auxgen.h"
#include "permute.h"

#define  A(c)  act+=c
#define  M(c)  mct+=c

void
prdiffft(double *f, ulong ldn, int is) //, int zp=0)
// prints code for a length-2**ldn fft
{
    ulong n = (1<<ldn);

    cout<<endl;

    if ( n<=1 )  return;

//    if ( n>4 )
//    {
//        cout << "double cc1, ss1;" << endl;
//        cout << "double cc3, ss3;" << endl;
//    }

    cout << "Complex t0, t1;" << endl;

    double s2pi = is*2.0*M_PI;  // pi*2*isign
    ulong n2 = 2*n;
    for (ulong k=1; k<ldn; k++)
    {
        cout << "// -------- k=" << k << ": --------" << endl;
        n2 >>= 1;  // == n>>(k-1) == n, n/2, n/4, ..., 4
        const double e = s2pi / n2;
        ulong n4 = n2 >> 2;  // == n/4, n/8, ..., 1

        {  // j==0:
            const ulong j = 0;
            cout << "// ---- j=" << j << ":" << endl;
            ulong ix = j;
            ulong id = (n2<<1);
            while ( ix<n-1 )
            {
                cout << "// ix=" << ix << ":" << endl;
                for (ulong i0=ix; i0<n; i0+=id)
                {
                    cout << "// i0=" << i0 << ":" << endl;
                    ulong i1 = i0 + n4;
                    ulong i2 = i1 + n4;
                    ulong i3 = i2 + n4;
                    cout<<"SUMDIFF3("<<idxf(f,i0)<<", "<<idxf(f,i2)<<", t0);"<<endl;  A(4);
                    cout<<"SUMDIFF3("<<idxf(f,i1)<<", "<<idxf(f,i3)<<", t1);"<<endl;  A(4);
//                    cout << "t1 *= Complex(0, "<<is<<");"<<endl;  M(4);
                    cout << "t1 = Complex(-t1.imag(), t1.real());"<<endl;
                    cout << "SUMDIFF2(t0, t1);" << endl;  A(4);
                    cout<<""<<idxf(f,i2)<<" = t0;"<<endl;
                    cout<<""<<idxf(f,i3)<<" = t1;"<<endl;
               }
               ix = (id<<1) - n2 + j;
               id <<= 2;
            }
        }


        for (ulong j=1; j<n4; j++)
        {
            cout << "{ // ---- k=" << k << ", j=" << j << ":" << endl;
            double a = j * e;
            double cc1,ss1, cc3,ss3;
            sincos(a, &ss1, &cc1);
            sincos(3.0*a, &ss3, &cc3);
            int cs2 = ( fabs(ss1*cc1-0.5) < 1e-12 ? 1 : 0 );  // c2==s2==1/sqrt(2)
//            cout << "// cc1=" << cc1 << "  ss1=" << ss1 << endl;

            if ( cs2 )   cout << "// cc1 = ss1 = ss3 = sqrt(1/2) = -cc3" << endl;
            else
            {
//                cout << "double cc1, ss1;" << endl;
//                cout << "double cc3, ss3;" << endl;
                prsincos("cc1", "ss1", is*2*j, n2);
                prsincos("cc3", "ss3", 3*is*2*j, n2);
            }

            ulong ix = j;
            ulong id = (n2<<1);
            while ( ix<n-1 )
            {
                cout << "// ix=" << ix << ":" << endl;
                for (ulong i0=ix; i0<n; i0+=id)
                {
                    cout << "// i0=" << i0 << ":" << endl;
                    ulong i1 = i0 + n4;
                    ulong i2 = i1 + n4;
                    ulong i3 = i2 + n4;

                    cout<<"SUMDIFF3("<<idxf(f,i0)<<", "<<idxf(f,i2)<<", t0);"<<endl;  A(4);
                    cout<<"SUMDIFF3("<<idxf(f,i1)<<", "<<idxf(f,i3)<<", t1);"<<endl;  A(4);
//                    cout << "t1 *= Complex(0, "<<is<<");"<<endl;  M(4);
                    cout << "t1 = Complex(-t1.imag(), t1.real());"<<endl;
                    cout << "SUMDIFF2(t0, t1);" << endl;  A(4);
                    if ( cs2 )
                    {
                        cout << "t0 *= SQRT1_2;" << endl;  M(2);
                        cout<<""<<idxf(f,i2)
                            <<" = Complex(t0.real()-t0.imag(), t0.real()+t0.imag());"
                            << endl;

                        cout << "t1 *= SQRT1_2;" << endl;  M(2);
                        cout<<""<<idxf(f,i3)
                            <<" = -Complex(t1.real()+t1.imag(), -t1.real()+t1.imag());"
                            << endl;
                    }
                    else
                    {
                        cout<<""<<idxf(f,i2)<<" = t0 * Complex(cc1, ss1);"<<endl;  M(4); A(2);
                        cout<<""<<idxf(f,i3)<<" = t1 * Complex(cc3, ss3);"<<endl;  M(4); A(2);
                    }
               }
               ix = (id<<1) - n2 + j;
               id <<= 2;
            }
            cout << "}" << endl;
        }
    }
    cout << endl;
    cout << "// ------------- final:" << endl;
    for (ulong ix=0, id=4;  ix<n;  id*=4)
    {
        cout << "// ix=" << ix << ":" << endl;
        for (ulong i0=ix; i0<n; i0+=id)
        {
            cout<<"SUMDIFF2("<<idxf(f,i0)<<", "<<idxf(f,i0+1)<<");"<<endl;  A(4);
        }
        ix = 2*(id-1);
    }
    cout << endl;
}
// ===================== end =====================


#include <stdlib.h>  // atol()

int
main(int argc, char **argv)
{
    if ( argc<=2 )
    {
        cerr << "need 2 args: ldn & is" << endl;
        exit(-1);
    }

    ulong ldn = atol(argv[1]);
    ulong n = (1<<ldn);

    int is = atol(argv[2]);

    int scrt = 1;  // revbin_permute before, DIT (0) or after, DIF (1) main loop

    prelude(n, "fft_(Complex *f)", scrt);

    if ( scrt )  prdiffft(0,ldn, is);
    else         abort();

    finale(n, scrt);
}
// ===================== end =====================

