
#include <math.h>

#include "revbinpermute.h"


void
inplace_haar(double *f, ulong ldn)
//
// transform wrt. to haar base
// alternative ordering of basis 
// allows inplace operation
//
{
    ulong n = (1<<(ulong)ldn);
    double s2 = sqrt(0.5);
    double v = 1.0;

    for (ulong js=2; js<=n; js<<=1)
    {
        v *= s2;

        for (ulong j=0,t=j+(js>>1); j<n; j+=js,t+=js)
        {
            double x = f[j];
            double y = f[t];
            f[j]  =  x+y;
            f[t]  = (x-y)*v;
        }
    }

    f[0] *= v; // *=1.0/sqrt(n); 

    revbin_permute(f,n);
}
// ============= end  ===============


void
inverse_inplace_haar(double *f, ulong ldn)
//
// inverse transform wrt. to haar base
// alternative ordering of basis 
// allows inplace operation
//
{
    ulong n = (1<<(ulong)ldn);
    double s2 = sqrt(2.0);
    double v = 1.0/sqrt(n);


    revbin_permute(f,n);

    f[0] *= v;

    for (ulong js=n; js>=2; js/=2)
    {
        for (ulong j=0,t=j+(js>>1); j<n; j+=js,t+=js)
        {
            double x = f[j];
            double y = f[t] * v;
            f[j]  =  x+y;
            f[t]  =  x-y;
        }

        v *= s2;
    }
}
// ============= end  ===============
