#if !defined __FXTDEFS_H
#define      __FXTDEFS_H

// echo 'scale=40; sqrt(1/2);' | bc -l
// echo -e 'default(realprecision,40); sqrt(1/2)' | gp -q
#define SQRT1_2      .707106781186547524400844362104
#define SQRT2       1.414213562373095048801688724209
#define COS_1_PI_8   .923879532511286756128183189397
#define SIN_1_PI_8   .382683432365089771728459984029


// ------  #defines are faster than inlines ...

// {u,v} |--> {u*u-v*v, 2*u*v}
#define CSQR2(u,v) \
{ double t = u*u-v*v;  v *= (u+u);  u = t; }

// {u,v} |--> {dn*(u*u-v*v), dn*(2*u*v)}
#define CSQR2_N(u,v,dn) \
{ double t = u*u-v*v;  v *= (u+u);  v *= dn;  u = t*dn; }

//{ u = a*a-b*b;  v = 2*a*b; }
// NEVER call like func(a,b,a,b) (i.e. input=output)
#define CSQR4(a,b,u,v) \
{ u = a*a-b*b;  v = a*b;  v += v; }

// u = u*c-v*s;  v = u*s+v*c
#define CMULT(c,s,u,v) \
{ double t = u*s+v*c;  u *= c;  u -= v*s;  v = t; }

// {u,v} = {dn*(u*c-v*s), dn*(u*s+v*c)}
#define CMULT_N(c,s,u,v,dn) \
{ double t = u*s+v*c;  u *= c;  u -= v*s;  u *= dn;  v = t*dn; }

//{ u = x*c-y*s;  v = x*s+y*c; }
// NEVER call like func(a,b,a,b) (i.e. input=output)
#define CMULT6(c,s,x,y,u,v) \
{ u = x*c-y*s;  v = x*s+y*c; }

//{ u = x*c-y*s;  v = x*s+y*c; }
// NEVER call like func(a,b,a,b) (i.e. input=output)
#define CMULT6M(c,s,x,y,u,v) \
{ u = x*c+y*s;  v = y*c-x*s; }


// xi <-- v*( 2*xi*xj + xi*xi - xj*xj )
// xj <-- v*( 2*xi*xj - xi*xi + xj*xj )
// used in fht based auto convolution
#define  FHT_SQR(xi,xj,v) \
{ typeof(xi) a = xi,  b = xj,  s1 = (a + b) * (a - b); \
a *= b;  a += a;  xi = (a+s1) * v; xj = (a-s1) * v; }

// used in fht based convolution
#define  FHT_MUL(xi,xj,yi,yj,v) \
{ typeof(xi) h1p = xi,  h1m = xj; \
typeof(xi) s1 = h1p + h1m,  d1 = h1p - h1m; \
typeof(xi) h2p = yi,  h2m = yj; \
yi = (h2p * s1 + h2m * d1) * v; \
yj = (h2m * s1 - h2p * d1) * v; }


// sin & cos of triple angle by algebra:
#define SINCOS3ALG(c,s,c3,s3) \
{ c3 = 4.0*c*(c*c-0.75); s3=4.0*s*(0.75-s*s); }


// {s, d}  |--> {s+d, s-d}
#define SUMDIFF2(s,d) \
{ typeof(s) t=s-d; s+=d; d=t; }

// {s, d}  |--> {0.5*(s+d),  0.5*(s-d)}
#define SUMDIFF2_05(s,d) \
{ typeof(s) t=(s-d)*0.5; s+=d; s*=0.5; d=t; }

//// {s, d}  |--> {x*(s+d), x*(s-d)}
//#define SUMDIFF2_N(s,d,x)  { typeof(s) t=(s-d)*x; s+=d; s*=x; d=t; }


// {a, b, d} |--> {a+b, b, a-b}  (used in split radix fft)
// NEVER call like func(a,b,a) or func(a,b,b) (i.e. input=output)
#define SUMDIFF3(a,b,d)  { d=a-b; a+=b; }

// {a,b,d} |--> {a+b, b, b-a}  (used in split radix fft)
// NEVER call like func(a,b,a) or func(a,b,b) (i.e. input=output)
#define SUMDIFF3R(a,b,d)  { d=b-a; a+=b; }

// {a, b, s} |--> {a, a-b, a+b}  (used in split radix fft)
// NEVER call like func(a,b,a) or func(a,b,b) (i.e. input=output)
#define DIFFSUM3(a,b,s)  { s=a+b; b=a-b; }

// {a, b, s} |--> {a, b-a, a+b}  (used in split radix fft)
// NEVER call like func(a,b,a) or func(a,b,b) (i.e. input=output)
#define DIFFSUM3R(a,b,s)  { s=a+b; b-=a; }


// NEVER call like func(a,b,a,b) (i.e. input=output)
#define SUMDIFF4(a,b,s,d)  { s=a+b; d=a-b; }

// NEVER call like func(a,b,a,b) (i.e. input=output)
#define SUMDIFF4_05(a,b,s,d)  { s=(a+b)*0.5; d=(a-b)*0.5; }

//// NEVER call like func(a,b,a,b,x) (i.e. input=output)
//#define SUMDIFF4_N(a,b,s,d,x)  { s=(a+b)*x; d=(a-b)*x; }

//--------------------------------------------

#endif  // !defined __FXTDEFS_H
