
#include "fxttypes.h"
#include "fxtaux.h" // copy()
#include "fxt.h" // fourier_shift()

#include <math.h>


static void
leftright(const Complex *a, Complex *le, Complex *ri, ulong n)
{
    for (ulong j=0; j<n; j++)
    {
        le[j] = a[j];
        ri[j] = a[n+j];
    }
}
// ================ end ====================


static void
recursive_dif2_fft_core(const Complex *a, ulong n, Complex *x, int is)
{
    if ( n==1 )
    {
        x[0] = a[0];
        return;
    }

    ulong nh = n/2;

    Complex *b = new Complex[nh];
    Complex *c = new Complex[nh];
    Complex *le = new Complex[nh];
    Complex *ri = new Complex[nh];


    leftright(a, le, ri, nh);

    for (ulong k=0; k<nh; k++)
    {
        Complex t =   (le[k] + ri[k]);
        ri[k] =       (le[k] - ri[k]);
        le[k] = t;
    }

    fourier_shift(ri, nh, is*0.5);

    recursive_dif2_fft_core(le, nh, b, is);
    recursive_dif2_fft_core(ri, nh, c, is);

    for (ulong k=0, j=0; k<nh; k++,j+=2)
    {
        x[j] =   b[k];
        x[j+1] = c[k];
    }

    delete [] c;
    delete [] b;
    delete [] le;
    delete [] ri;
}
// ================ end ====================

void
recursive_dif2_fft(Complex *a, ulong ldn, int is)
//
// very inefficient, just here to demonstrate the
// recursive fast fourier transform
//
{
    ulong n = (1<<ldn);
    Complex *x = new Complex[n];

    recursive_dif2_fft_core(a, n, x, is);
    copy(x, a, n);

    delete [] x;
}
// ================ end ====================

