
#include "fxttypes.h"
#include "fxtaux.h" // copy()
#include "permute.h"
#include "fxt.h" // hartley_shift_05()

#include <math.h>


static void
evenodd_permute(const double *a, double *ev, double *od, ulong n)
{
    for (ulong k=0,j=0; j<n; k+=2,j++)
    {
        ev[j] = a[k];
        od[j] = a[k+1];
    }
}
// ================ end ====================


static void
recursive_dit2_fht_core(const double *a, ulong n, double *x)
{
    if ( n==1 )
    {
        x[0] = a[0];
        return;
    }

    ulong nh = n/2;


    double *b = new double[nh];
    double *c = new double[nh];
    double *ev = new double[nh];
    double *od = new double[nh];


    evenodd_permute(a, ev, od, nh);
    recursive_dit2_fht_core(ev, nh, b);
    recursive_dit2_fht_core(od, nh, c);
    hartley_shift_05(c, nh);

    for (ulong k=0; k<nh; k++)
    {
        x[k]    = b[k] + c[k];
        x[k+nh] = b[k] - c[k];
    }

    delete [] c;
    delete [] b;
    delete [] ev;
    delete [] od;
}
// ================ end ====================

void
recursive_dit2_fht(double *a, ulong ldn)
//
// very inefficient, just here to demonstrate the
// recursive fast hartley transform
//
{
    ulong n = (1<<ldn);
    double *x = new double[n];

    recursive_dit2_fht_core(a, n, x);
    copy(x, a, n);

    delete [] x;
}
// ================ end ====================

