
#include "auxbit.h"
#include "fxt.h"
#include "ldn2rc.h"


void
matrix_fft(double *fr, double *fi, ulong ldn, int is)
// matrix (aka four-step) fft
// useful for arrays larger than 2nd-level cache
{
    ulong r, c;
    ldn2rc(ldn, r, c);
    column_ffts(fr, fi, r, c, is, 0, 0, 0);
    row_weighted_ffts(fr, fi, r, c, is);
    matrix_transpose2(fr, r, c);
    matrix_transpose2(fi, r, c);
}
// =================== end ===================


void
matrix_fft0(double *fr, double *fi, ulong ldn, int is)
// matrix (aka four-step) fft
// useful for arrays larger than 2nd-level cache
// version for zero padded data
{
    ulong r, c;
    ldn2rc(ldn, r, c);
    column_ffts(fr, fi, r, c, is, 1, 0, 0);
    row_weighted_ffts(fr, fi, r, c, is);
    matrix_transpose2(fr, r, c);
    matrix_transpose2(fi, r, c);
}
// =================== end ===================


void
matrix_fft(Complex *f, ulong ldn, int is)
// matrix (aka four-step) fft
// useful for arrays larger than 2nd-level cache
{
    ulong r, c;
    ldn2rc(ldn, r, c);
    column_ffts(f, r, c, is, 0, 0);
    row_weighted_ffts(f, r, c, is);
    matrix_transpose2(f, r, c);
}
// =================== end ===================


void
matrix_fft0(Complex *f, ulong ldn, int is)
// matrix (aka four-step) fft
// useful for arrays larger than 2nd-level cache
// version for zero padded data
{
    ulong r, c;
    ldn2rc(ldn, r, c);
    column_ffts(f, r, c, is, 1, 0);
    row_weighted_ffts(f, r, c, is);
    matrix_transpose2(f, r, c);
}
// =================== end ===================


