
#include "fxt.h"
#include "auxbit.h"


void
row_weighted_auto_convolutions(double *fr, double *fi, ulong r, ulong c, double v)
//
// r x c matrix (r rows, c columns)
//
// v!=0.0 chooses alternative normalization
{
    const ulong ldc = ld(c);

    double *pr = fr, *pi = fi;
    for (ulong k=0; k<r; ++k)
    {
        double w = (double)k/r;
        weighted_complex_auto_convolution(pr, pi, ldc, w, v);
        pr += c;
        pi += c;
    }
}
// ================== end ===================


void
row_weighted_auto_convolutions(Complex *f, ulong r, ulong c, double v)
//
// r x c matrix (r rows, c columns)
//
// v!=0.0 chooses alternative normalization
{
    const ulong ldc = ld(c);

    Complex *p = f;
    for (ulong k=0; k<r; ++k)
    {
        double w = (double)k/r;
        weighted_complex_auto_convolution(p, ldc, w, v);
        p += c;
    }
}
// ================== end ===================

