
#include <iostream.h>

#include "mod.h"
#include "moduli.h"
#include "inline.h"  //  abs()
#include "jjassert.h"


umod_t          mod::modulus = 0;
umod_t          mod::mm1 = 0;
ldouble         mod::m1dd = 0.0;
factorization   mod::modfact;

double          mod::mbitsd = 0.0;
uint            mod::mbits = 0;
 
umod_t          mod::maxorder = 0;
factorization   mod::xfact;
uint            mod::max2pow = 0;

umod_t          mod::phi = 0;
factorization   mod::phifact;

mod    mod::maxordelem;
mod    mod::invmaxordelem;
mod    mod::zero;
mod    mod::one;
mod    mod::two;
mod    mod::minus_one;

mod  * mod::root_2pow = 0;
mod  * mod::invroot_2pow = 0;


// 'mod_initializer' initialises the 'mod' class
// modulus M is choosen in modvals.h
//mod_init mod::mod_initializer( M );
mod_init  * mod::mod_initializer = new mod_init( M, MF );


void
mod::reinit(umod_t m, factorization *mf/*=0*/)
{
    delete mod::mod_initializer;

    if ( mf )  mod::mod_initializer = new mod_init(m,(*mf).prime);
    else       mod::mod_initializer = new mod_init(m,0);
}
//------------------------


mod
mod::root2pow(int ldorder)  // root of order 2^ldorder
{
    jjassert2( abs(ldorder) <=  (int)max2pow, 
               "requested impossible root of order 2**ldorder" );

    if ( ldorder>=0 )  return root_2pow[ldorder];
    else               return invroot_2pow[-ldorder];
}
//------------------------


int
mod::modulus_prime()
{
    return  (modfact.prime[0]==modulus);
}
//------------------------


int
mod::modulus_cyclic()
{
    int e2 = modfact.exponent(2);

    if ( 1==modfact.npr )
    {
        if ( 0==e2 )  return 1;     // p**k, p!=2
        else if ( e2<3 ) return 1;  // 2**k, k<3
        return 0;
    }

    if ( (2==modfact.npr) && (e2==1) )  return 1;  // 2 * p**k, p!=2

    return 0;
}
//------------------------


void
mod::print_info()
{
    mod_info0();
    mod_info1();
    mod_info2();
    mod_info3();
    mod_info4();
    mod_info99();
}
// -------------------


istream&  operator >> (istream& is, mod& h)
{
    is >> h.x;
    return is;
}
// -------------------


ostream&  operator << (ostream& os, const mod& h)
{
    os << h.x;
    return os;
}
// -------------------
