#if !defined __MODARITH_H
#define      __MODARITH_H

//
// (inline) ARITHMETIC modulo mod::modulus
// (cf. arithmodm.cc)
//

#include <assert.h>

#include "mtypes.h"


#define MODULUS    (mod::modulus)
#define M1DD       (mod::m1dd)


inline umod_t
mod_m(umod_t a)
{
    if ( a>=(umod_t)MODULUS )  a %= (umod_t)MODULUS;
    return a;
}
// ============


inline umod_t
incr_m(umod_t a)
{
    a++;
    if ( a==MODULUS )  a = 0;
    return a;
}
// ============


inline umod_t
decr_m(umod_t a)
{
    if ( a==0 )  a = MODULUS-1;
    else         --a;
    return a;
}
// ============


inline umod_t
sub_m(umod_t a, umod_t b)
{
    if ( a>=b )  return  a-b;
    else         return  MODULUS-b+a;
}
// ============


inline umod_t
add_m(umod_t a, umod_t b)
{
    if ( 0==b )  return a;

//    return  sub_m(a,MODULUS-b); ==
    umod_t r = MODULUS-b;
    if ( a>=r )  return  a-r;
    else         return  MODULUS-r+a;
}
// ============




#if  ( USE_64BIT_MOD_T )

#if  ( USE_64BIT_MODULUS )
#error  "no 64bit multiply yet"
// jjnote: todo: 64bit mod multiply
#else


#define LD12  ((ldouble)1/2)

inline umod_t
mul_m(const umod_t a, const umod_t b)
{
    umod_t x = a * b;

#if  ( USE_LEQ_62BIT_MODULUS )
    // "using M1DD fails for some moduli >62bit, e.g. 0x7ffedc0000000001 "
    umod_t y = MODULUS * (umod_t)( (ldouble)a*(ldouble)b * (M1DD)+LD12 );
#else
    umod_t y = MODULUS * (umod_t)((ldouble)a*(ldouble)b / MODULUS+LD12 );
#endif // USE_LEQ_62BIT_MODULUS

    smod_t r = (smod_t)(x-y);
    if ( r<0 )  r += MODULUS;

//    smod_t q = (smod_t) (LD12 + (ldouble)a * (ldouble)b * (M1DD));
//    smod_t r = (smod_t)((umod_t)a * (umod_t)b - (umod_t)MODULUS * (umod_t)q);
//    if ( r<0 )   {r += MODULUS; q--;}

//    cout << " mod( " << a << " * " << b << ", " << MODULUS << ") == " << r << endl;
    return  (umod_t)r;
}
// ============ end ===========
#endif  // USE_64BIT_MODULUS


#else // USE_64BIT_MOD_T

// 32 bit mod type:
inline umod_t
mul_m(const mod_t a, const mod_t b)
{
    uint64 r= (uint64)a*(uint64)b;
    r = r%(uint64)MODULUS;
    return  (umod_t)r;
}
// ============ end ===========

#endif // USE_64BIT_MOD_T



#endif  // !defined __MODARITH_H
