
#include "mod.h"

#include <iostream.h>


#if    ( USE_MODM==1 )
#warning "FYI: USE_MODM is #defined "
#endif


void
mod_info0()
{
    cout << "-------- start MOD_INIT():  m=" << mod::modulus <<  " --------" << endl;
}
// ------------------------------

void
mod_info99()
{
    cout << "-------- end MOD_INIT(). --------" << endl;
}
// ------------------------------

void
mod_info1()
{
    umod_t m = mod::modulus;

    /*
      cout << "using ";
      #if  ( USE_64BIT_MOD_T )
      cout << "64 bit";
      #else
      cout << "32 bit";
      #endif
      cout << " mod type " << endl;
      */

    cout << "modulus= " << m
         << " == 0x" << hex << m << dec << endl;

    cout << "modulus is ";
    if ( !mod::modulus_cyclic() )  cout << "NOT ";
    cout << "cyclic" << endl;

    cout << "modulus is ";
    if ( mod::modfact.prime[0]==mod::modulus )
    {
        cout << "prime " << endl;
    }
    else
    {
        cout << "composite  ";
        cout << " == " << mod::modfact << endl;
    }

    cout << "bits(modulus)= ";
    cout.precision(8);
    cout << mod::mbitsd;

//    cout.precision(16);
    double d = mod::mbits - mod::mbitsd;
    if ( d!=0 )  cout << "  == " << mod::mbits << " - " << d;

    cout << endl;
}
// -------------------


void
mod_info2()
{
    cout << "phi(modulus)= " << (mod::phi)
         << " == 0x" << hex <<  (mod::phi) << dec
         << " == " << mod::phifact
//         << "   ==phi(modulus)"
         << endl;

    cout << "maxorder= " << (mod::maxorder)
         << " == 0x" << hex <<  (mod::maxorder) << dec
         << " == " << mod::xfact
//         << "   (maximal possible order) "
         << endl;
}
// -------------------


void
mod_info3()
{
    cout << "maxordelem= " << (mod::maxordelem)
         << " == 0x" << hex << (mod::maxordelem) << dec
         << endl;

    cout << "invmaxordelem= "
         << mod::invmaxordelem
         << " == 0x" << hex << (mod::invmaxordelem) << dec
         << endl;

    umod_t r = order((uint)2);
    cout << "order(2)= " << r
         << " == " << factorization(r) << endl;

    for (umod_t x=4, xe=2;  x<mod::modulus;  x*=2, ++xe)
    {
        r = order(x);
        for (umod_t z=4, ze=2;  z<mod::modulus;  z*=2, ++ze)
        {
            if ( r==z )
            {
                cout << "order(2^" << xe << ")=2^" << ze << endl;
                goto done;
            }
        }
    }
 done: ;
}
// ------------------------------


void
mod_info4()
{
    umod_t m2 = mod::max2pow;
    cout << "max2pow= " << m2
//         << "   (root of order 2**ldn exists for ldn<=max2pow)"
         << "   (max FFT length = 2**" << m2
         << " == " << ((umod_t)1<<m2) << ")"
         << endl;
    if ( mod::modfact.prime[0]==2 )
        cout << " 2\\modulus =--> cannot do inverse (length 2**n) FFTs !"
             << endl;  

    cout << "root2pow(max2pow)=" << mod::root2pow(m2)
         << "   root2pow(-max2pow)=" << mod::root2pow(-m2)
         << endl;

    if ( m2 > 0 )
    {
        if ( mod::root2pow(1) != (mod::mm1) )
            cout << "root2pow(1)=" << mod::root2pow(1) << " != -1  (!)"
                 << endl;
    }

//    for (int k=0; k<=m2; ++k)
//    {
//        cout << "root2pow(" << k << ")=" << mod::root2pow(k);
//        cout << "   root2pow(" << -k << ")=" << mod::root2pow(-k);
//        cout << endl;
//    }
}
// ------------------------------


//void
//mod_info5()
//{
//    // ------- montgomery section:
//    cout << "mg_bits=" << mod::mg_bits << endl;
//    cout << "mg_mask=" << mod::mg_mask << endl;
//    cout << "mg_r=" << mod::mg_r << endl;
//    cout << "mg_r_prime=" << mod::mg_r_prime << endl;
//    cout << "mg_m_prime=" << mod::mg_m_prime << endl;
//}
//// ------------------------------

