#if !defined __NTT_H
#define      __NTT_H

#include "mod.h"

// jjmagictag

// mod/nttdit4.cc:
void ntt_dit4(mod *f, ulong ldn, int is);

// mod/nttdif4.cc:
void ntt_dif4(mod *f, ulong ldn, int is);


// mod/nttdit2.cc:
void ntt_dit2(mod *f, ulong ldn, int is);

// mod/nttdif2.cc:
void ntt_dif2(mod *f, ulong ldn, int is);

// mod/nttdif2nc.cc:
void ntt_dif2_noncyclic(mod *f, ulong ldn, int is);

// mod/nttcnvl.cc:
void ntt_auto_convolution(mod *f, ulong ldn);
void ntt_convolution(mod *f, mod *g, ulong ldn);
void ntt_convolution(mod *f, mod *g, mod *h, ulong ldn);
void double_to_mod_by_force(double *f, ulong n);
void mod_to_double_by_force(mod *m, ulong n);
//
// for hfloat:
void ntt_convolution(double *f, double *g, ulong ldn);
void ntt_auto_convolution(double *f, ulong ldn);

// mod/slownttcnvl.cc:
void slow_mod_convolution(mod *f, mod *g, ulong n);
void slow_mod_convolution(double *f, double *g, ulong n);


// mod/nttskip.cc:
void skip_ntt(mod *f, ulong n, ulong d, mod *w, int is);
void skip_ntt0(mod *f, ulong n, ulong d, mod *w, int is);

// mod/nttndim.cc:
void ntt_ndim(mod *f, ulong ndim, ulong *ldn, int is);


// mod/slowntt.cc:  (brute force (slow) mod ft)
void slow_ntt(mod *f, ulong n, int is);

// mod/mrevbinpermute.cc:
void revbin_permute(mod *fr, ulong n);
void revbin_permute0(mod *fr, ulong n);

// jjmagictag


// mod/nttaux.cc:
void sumdiff2(mod *f, ulong n);
ulong ld(ulong x);

// jj_end_autodoc

//// following moved to the 'bucket' directory:
//
//// mod/nttlearn.cc:  (learner's simple versions)
//void ntt_dif2l(mod *f, ulong ldn, int is);
//void ntt_dit2l(mod *f, ulong ldn, int is);


#endif // !defined __NTT_H
