
#include "fxtmult.h"

#include <math.h>
#include <assert.h>


inline void
d_divmod(double &a, double &cy, double drx, double d1rx)
{
    a = floor( drx * modf( (a+cy+0.5)*(d1rx), &cy) );
}
// -------------------


// a few asserts outside loops that trap many errors:
#define  CARRYCHECK  1  // 0 or 1 (default)

ulong
carry(double *a, ulong n, uint rx)
//
//  carry operation for fft-multiplication (and sqr)
//
//  returns:
//  if(no overflow)  0;
//  else: the new most significant digit 
//
{
#if  ( CARRYCHECK==1 )
    double ns = (double)rx-1;  ns *= ns;
    assert( ns >= floor(0.5+a[0]) );
    assert( ns >= floor(0.5+a[n-2]) );
    assert( 0  == floor(0.5+a[n-1]) );
#endif // CARRYCHECK==1

    double cy = 0.0;
    carry_thru(a, n, rx, cy);

    if ( cy==0 )  return 0;
    else
    {
        cy = floor(0.5+cy);
#if  ( CARRYCHECK==1 )
        assert( cy >= 0 );
        assert( cy < rx );
#endif  // CARRYCHECK==1
        return (ulong)cy; 
    }
}
//========================== end =================================



void
carry_thru(double *a, ulong n, uint rx, double &cy)
// carry through region a[n-1,...,0]
{
    const double drx  = (double)rx;
    const double d1rx = 1.0/drx;
    n--;
    do
    {
//        assert( fabs(a[n]-floor(0.5+a[n])) < 0.25 );

        d_divmod(a[n], cy, drx, d1rx);

//        assert( a[n]>=0 );
//        assert( cy>=0 );
    }
    while ( n-- );
}
//===================== end =======================
