#if !defined __FXTMULT_H
#define      __FXTMULT_H

#include "./../include/fxttypes.h"   // for ulong, LIMB


class fxtmult
{
public:
    static int  square(const LIMB *a, ulong an,
                       LIMB *c, ulong cn,
                       uint rx);

    static int  multiply(const LIMB *a, ulong an,
                         const LIMB *b, ulong bn,
                         LIMB *c, ulong cn,
                         uint rx);

    // convolutions used:
    static void (* mulcnvl1)(double *, double *, ulong);  // mult inside cache
    static void (* mulcnvl2)(double *, double *, ulong); // mult beyond cache size
    static void (* sqrcnvl1)(double *, ulong);  // sqr inside cache
    static void (* sqrcnvl2)(double *, ulong); // sqr beyond cache size
    // ... beyond total ramsize mass storage convolutions are used

    // fxtsquare.cc:
    static int fxt_square(const LIMB *a, ulong an,
                          LIMB *c, ulong cn,
                          uint rx);

    // fxtmultiply.cc:
    static int fxt_multiply(const LIMB *a, ulong an,
                            const LIMB *b, ulong bn,
                            LIMB *c, ulong cn,
                            uint rx);

    // masssquare.cc:
    static int disk_square(const LIMB *a, ulong an,
                           LIMB *c, ulong cn,
                           uint rx,
                           ulong fn, ulong al);

    // massmultiply.cc:
    static int disk_multiply(const LIMB *a, ulong an,
                             const LIMB *b, ulong bn,
                             LIMB *c, ulong cn,
                             uint rx,
                             ulong fn, ulong al);

    static int  checkmult;  // whether to do the sum of digits test
    static int  verbosity;  // whether to echo which kind of mult is in progress   

    static ulong max_noswap_dfxtlen();
    static ulong max_cache_dfxtlen();

    static ulong ndoubles_fxtsqr(ulong an);
    static ulong ndoubles_fxtmul(ulong an, ulong bn);
    static ulong alpha_sqr(ulong an);
    static ulong alpha_mul(ulong an, ulong bn);
    static double swapfile_bytes(ulong an);

    static const char * const filename1;
    static const char * const filename2;

    static double  fxtwork;      // how much work was done in fast transforms
    static double  diskio;       // disk I/O in bytes
    static double  diskiotime;
    static double  ndiskseeks;   // # of seek operations

    static void  print_info(ulong n=0);
    static void  print_statistics(ulong n=0);

    static const char * const classname;
};
//-----------------------------


// auxil.cc:
ulong next_dfxtlen(ulong n);
ulong previous_dfxtlen(ulong n);

ulong sum_of_digits(const double *a, ulong n, double nine, ulong s);
ulong sum_of_digits(const LIMB *a, ulong n, ulong nine, ulong s);

ulong mult_sum_of_digits(const LIMB *a, ulong an,
                         const LIMB *b, ulong bn,
                         ulong nine);

ulong sqr_sum_of_digits(const LIMB *a, ulong an, ulong nine);


// carry.cc:
ulong carry(double *a, ulong n, uint rx);
void carry_thru(double *a, ulong n, uint rx, double &cy);

//// multsqr.cc:
//int fxt_multsqr(const LIMB *a, ulong an,
//                const LIMB *b, ulong bn, 
//                LIMB *c, ulong cn,
//                uint rx);

#endif // !defined __FXTMULT_H
