
#include "fxtmult.h"
#include "copy.h"
#include "auxbit.h"
#include "workspace.h"
#include "fxt.h"

#include <jjassert.h>
#include <iostream.h>


int // static
fxtmult::fxt_square(const LIMB *a, ulong an,
                    LIMB *c, ulong cn,
                    uint rx)
//
// return: if(right_shift occured)
//
{
    const ulong nine = rx-1;
    ulong qsm=0, qsp=0;
    if ( checkmult )  qsm = sqr_sum_of_digits(a, an, nine);

    ulong n = ndoubles_fxtsqr(an);
    double *f;
    workspace::get_noswap_ws(f,n);
    copy(a, an, f, n);

    ulong ldn = ld(n);
    fxtwork +=  2.0 * n * ldn;
    if ( max_cache_dfxtlen() >= n ) // fits in cache
    {
        if  ( verbosity>0 )  { cout << ".";  cout.flush(); }
        sqrcnvl1(f, ldn);
    }
    else
    {
        if  ( verbosity>0 )  { cout << ":";  cout.flush(); }
        sqrcnvl2(f, ldn);
    }

//    cout << __FUNCTION__ <<":  an=" << an << "  cn=" << cn << "  n=" << n << endl;

    ulong cy = carry(f, n, rx);

    if( 0==cy )
    {
        copy(f, n, c, cn);
    }
    else
    {
	c[0] = (LIMB)cy;
        copy(f, n, c+1, cn-1);  // c[cn-1] is lost here
    }

//    if  ( verbosity>0 )  { cout << "]";  cout.flush(); }

    if ( checkmult )
    {
        qsp = sum_of_digits(f, n, nine, cy);
        jjassert2( qsm==qsp, "sum_of_digits test failed" );
    }

    workspace::let_ws();

    return (cy!=0);
}
//--------------------- end -----------------------
