
#include "auxbit.h"
#include "fxt.h"


#define FFT(re,im,ldn,is)  fht_fft(re,im,ldn,is)


void
twodim_fft(double *fr, double *fi, ulong r, ulong c, int is)
{
    ulong n = r * c;

    // fft over rows:
    ulong ldc = ld(c);
    for (ulong k=0; k<n; k+=c)  FFT(fr+k,fi+k,ldc,is);

    // fft over columns:
    double *wr = new double[2*r];
    double *wi = wr + r;
    for (ulong k=0; k<c; k++)  skip_fft(fr+k,fi+k,r,c,wr,wi,is);
    delete [] wr;
}
// =============== end =========== 
