
#include "revbinpermute.h"
#include "complextype.h"


void
evenodd_permute(double *f, long n)
//
// lower half --> even indices
// higher half --> odd indices
//
// same as transposing the array as 2 x n/2 - matrix
//
// useful to combine real/imag part into a Complex array
// called by real_imag_to_complex()
{
//    ulong nh = n/2;
//    revbin_permute(f, nh);  revbin_permute(f+nh, nh);
//    revbin_permute(f, n);
    // =^=
    revbin_permute(f, n);
    revbin_permute((Complex *)f, n/2);
}
//============= end ============


void
inverse_evenodd_permute(double *f, long n)
//
// inverse of evenodd_permute():
// put part of data with even indices
// sorted into the lower half,
// odd part into the higher half
//
// same as transposing the array as n/2 x 2 - matrix
//
// useful to separate real/imag part from a Complex array
// called by complex_to_real_imag()
{
//    ulong nh = n/2;
//    revbin_permute(f, n);
//    revbin_permute(f, nh);  revbin_permute(f+nh, nh);
    // =^=
    revbin_permute((Complex *)f, n/2);
    revbin_permute(f, n);
}
//============= end ============
